/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jmx.Server;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.NanoClockFactory;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContextKey;

public class LoggerContext
extends AbstractLifeCycle
implements org.apache.logging.log4j.spi.LoggerContext,
ConfigurationListener {
    public static final String PROPERTY_CONFIG = "config";
    private static final long serialVersionUID = 1L;
    private static final Configuration NULL_CONFIGURATION = new NullConfiguration();
    private final ConcurrentMap<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final CopyOnWriteArrayList<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList();
    private volatile Configuration configuration = new DefaultConfiguration();
    private Object externalContext;
    private String contextName;
    private volatile URI configLocation;
    private Cancellable shutdownCallback;
    private final Lock configLock = new ReentrantLock();

    public LoggerContext(String name) {
        this(name, null, (URI)null);
    }

    public LoggerContext(String name, Object externalContext) {
        this(name, externalContext, (URI)null);
    }

    public LoggerContext(String name, Object externalContext, URI configLocn) {
        this.contextName = name;
        this.externalContext = externalContext;
        this.configLocation = configLocn;
    }

    public LoggerContext(String name, Object externalContext, String configLocn) {
        this.contextName = name;
        this.externalContext = externalContext;
        if (configLocn != null) {
            URI uri;
            try {
                uri = new File(configLocn).toURI();
            }
            catch (Exception ex) {
                uri = null;
            }
            this.configLocation = uri;
        } else {
            this.configLocation = null;
        }
    }

    public static LoggerContext getContext() {
        return (LoggerContext)LogManager.getContext();
    }

    public static LoggerContext getContext(boolean currentContext) {
        return (LoggerContext)LogManager.getContext((boolean)currentContext);
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, URI configLocation) {
        return (LoggerContext)LogManager.getContext((ClassLoader)loader, (boolean)currentContext, (URI)configLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LOGGER.debug("Starting LoggerContext[name={}, {}]...", new Object[]{this.getName(), this});
        if (this.configLock.tryLock()) {
            try {
                if (this.isInitialized() || this.isStopped()) {
                    this.setStarting();
                    this.reconfigure();
                    if (this.configuration.isShutdownHookEnabled()) {
                        this.setUpShutdownHook();
                    }
                    this.setStarted();
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
        LOGGER.debug("LoggerContext[name={}, {}] started OK.", new Object[]{this.getName(), this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Configuration config) {
        LOGGER.debug("Starting LoggerContext[name={}, {}] with configuration {}...", new Object[]{this.getName(), this, config});
        if (this.configLock.tryLock()) {
            try {
                if (this.isInitialized() || this.isStopped()) {
                    if (this.configuration.isShutdownHookEnabled()) {
                        this.setUpShutdownHook();
                    }
                    this.setStarted();
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
        this.setConfiguration(config);
        LOGGER.debug("LoggerContext[name={}, {}] started OK with configuration {}.", new Object[]{this.getName(), this, config});
    }

    private void setUpShutdownHook() {
        LoggerContextFactory factory;
        if (this.shutdownCallback == null && (factory = LogManager.getFactory()) instanceof ShutdownCallbackRegistry) {
            LOGGER.debug(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Shutdown hook enabled. Registering a new one.");
            try {
                this.shutdownCallback = ((ShutdownCallbackRegistry)factory).addShutdownCallback(new Runnable(){

                    @Override
                    public void run() {
                        LoggerContext context = LoggerContext.this;
                        AbstractLifeCycle.LOGGER.debug(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Stopping LoggerContext[name={}, {}]", new Object[]{context.getName(), context});
                        context.stop();
                    }

                    public String toString() {
                        return "Shutdown callback for LoggerContext[name=" + LoggerContext.this.getName() + ']';
                    }
                });
            }
            catch (IllegalStateException e) {
                LOGGER.error(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Unable to register shutdown hook because JVM is shutting down.", (Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Unable to register shutdown hook due to security restrictions", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LOGGER.debug("Stopping LoggerContext[name={}, {}]...", new Object[]{this.getName(), this});
        this.configLock.lock();
        try {
            if (this.isStopped()) {
                return;
            }
            this.setStopping();
            try {
                Server.unregisterLoggerContext(this.getName());
            }
            catch (Exception ex) {
                LOGGER.error("Unable to unregister MBeans", (Throwable)ex);
            }
            if (this.shutdownCallback != null) {
                this.shutdownCallback.cancel();
                this.shutdownCallback = null;
            }
            Configuration prev = this.configuration;
            this.configuration = NULL_CONFIGURATION;
            this.updateLoggers();
            prev.stop();
            this.externalContext = null;
            LogManager.getFactory().removeContext((org.apache.logging.log4j.spi.LoggerContext)this);
            this.setStopped();
        }
        finally {
            this.configLock.unlock();
        }
        LOGGER.debug("Stopped LoggerContext[name={}, {}]...", new Object[]{this.getName(), this});
    }

    public String getName() {
        return this.contextName;
    }

    public Logger getRootLogger() {
        return this.getLogger("");
    }

    public void setName(String name) {
        this.contextName = Objects.requireNonNull(name);
    }

    public void setExternalContext(Object context) {
        this.externalContext = context;
    }

    public Object getExternalContext() {
        return this.externalContext;
    }

    public Logger getLogger(String name) {
        return this.getLogger(name, null);
    }

    public Collection<Logger> getLoggers() {
        return this.loggers.values();
    }

    public Logger getLogger(String name, MessageFactory messageFactory) {
        String key = LoggerContextKey.create((String)name, (MessageFactory)messageFactory);
        Logger logger = (Logger)((Object)this.loggers.get(key));
        if (logger != null) {
            AbstractLogger.checkMessageFactory((ExtendedLogger)logger, (MessageFactory)messageFactory);
            return logger;
        }
        logger = this.newInstance(this, name, messageFactory);
        key = LoggerContextKey.create((String)name, (MessageFactory)logger.getMessageFactory());
        Logger prev = this.loggers.putIfAbsent(key, logger);
        return prev == null ? logger : prev;
    }

    public boolean hasLogger(String name) {
        return this.loggers.containsKey(LoggerContextKey.create((String)name));
    }

    public boolean hasLogger(String name, MessageFactory messageFactory) {
        return this.loggers.containsKey(LoggerContextKey.create((String)name, (MessageFactory)messageFactory));
    }

    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        return this.loggers.containsKey(LoggerContextKey.create((String)name, messageFactoryClass));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addFilter(Filter filter) {
        this.configuration.addFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.configuration.removeFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration setConfiguration(Configuration config) {
        Objects.requireNonNull(config, "No Configuration was provided");
        this.configLock.lock();
        try {
            Configuration prev = this.configuration;
            config.addListener(this);
            ConcurrentMap map = (ConcurrentMap)config.getComponent("ContextProperties");
            try {
                map.putIfAbsent("hostName", NetUtils.getLocalHostname());
            }
            catch (Exception ex) {
                LOGGER.debug("Ignoring {}, setting hostName to 'unknown'", new Object[]{ex.toString()});
                map.putIfAbsent("hostName", "unknown");
            }
            map.putIfAbsent("contextName", this.contextName);
            config.start();
            this.configuration = config;
            this.updateLoggers();
            if (prev != null) {
                prev.removeListener(this);
                prev.stop();
            }
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_CONFIG, prev, config));
            try {
                Server.reregisterMBeansAfterReconfigure();
            }
            catch (Throwable t) {
                LOGGER.error("Could not reconfigure JMX", t);
            }
            Log4jLogEvent.setNanoClock(NanoClockFactory.createNanoClock());
            Configuration configuration = prev;
            return configuration;
        }
        finally {
            this.configLock.unlock();
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(Objects.requireNonNull(listener, "listener"));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public URI getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(URI configLocation) {
        this.configLocation = configLocation;
        this.reconfigure(configLocation);
    }

    private void reconfigure(URI configURI) {
        ClassLoader cl = ClassLoader.class.isInstance(this.externalContext) ? (ClassLoader)this.externalContext : null;
        LOGGER.debug("Reconfiguration started for context[name={}] at URI {} ({}) with optional ClassLoader: {}", new Object[]{this.contextName, configURI, this, cl});
        Configuration instance = ConfigurationFactory.getInstance().getConfiguration(this.contextName, configURI, cl);
        this.setConfiguration(instance);
        String location = this.configuration == null ? "?" : String.valueOf(this.configuration.getConfigurationSource());
        LOGGER.debug("Reconfiguration complete for context[name={}] at URI {} ({}) with optional ClassLoader: {}", new Object[]{this.contextName, location, this, cl});
    }

    public void reconfigure() {
        this.reconfigure(this.configLocation);
    }

    public void updateLoggers() {
        this.updateLoggers(this.configuration);
    }

    public void updateLoggers(Configuration config) {
        for (Logger logger : this.loggers.values()) {
            logger.updateConfiguration(config);
        }
    }

    @Override
    public synchronized void onChange(Reconfigurable reconfigurable) {
        LOGGER.debug("Reconfiguration started for context {} ({})", new Object[]{this.contextName, this});
        Configuration newConfig = reconfigurable.reconfigure();
        if (newConfig != null) {
            this.setConfiguration(newConfig);
            LOGGER.debug("Reconfiguration completed for {} ({})", new Object[]{this.contextName, this});
        } else {
            LOGGER.debug("Reconfiguration failed for {} ({})", new Object[]{this.contextName, this});
        }
    }

    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        return new Logger(ctx, name, messageFactory);
    }
}

