/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.IChromosomePool;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;

public class ChromosomeForTesting
extends Chromosome {
    private boolean m_isCloned;

    public ChromosomeForTesting() throws InvalidConfigurationException {
        super(Genotype.getStaticConfiguration());
    }

    public ChromosomeForTesting(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
    }

    public ChromosomeForTesting(Configuration a_config, Gene[] a_initialGenes) throws InvalidConfigurationException {
        super(a_config, a_initialGenes);
    }

    public int getComputedTimes() {
        return TestResultHolder.computedTimes;
    }

    public void resetComputedTimes() {
        TestResultHolder.computedTimes = 0;
    }

    public double getFitnessValue() {
        if (this.m_isCloned && this.m_fitnessValue < 0.0) {
            ++TestResultHolder.computedTimes;
        }
        return super.getFitnessValue();
    }

    public void resetIsCloned() {
        this.m_isCloned = false;
    }

    public IChromosome randomInitialChromosome2() throws InvalidConfigurationException {
        IChromosome randomChromosome;
        if (this.getConfiguration() == null) {
            throw new IllegalArgumentException("Configuration instance must not be null");
        }
        this.getConfiguration().lockSettings();
        IChromosomePool pool = this.getConfiguration().getChromosomePool();
        if (pool != null && (randomChromosome = pool.acquireChromosome()) != null) {
            Gene[] genes = randomChromosome.getGenes();
            RandomGenerator generator = this.getConfiguration().getRandomGenerator();
            for (int i = 0; i < genes.length; ++i) {
                genes[i].setToRandomValue(generator);
            }
            randomChromosome.setFitnessValueDirectly(-1.0);
            return randomChromosome;
        }
        IChromosome sampleChromosome = this.getConfiguration().getSampleChromosome();
        Gene[] sampleGenes = sampleChromosome.getGenes();
        Gene[] newGenes = new Gene[sampleGenes.length];
        RandomGenerator generator = this.getConfiguration().getRandomGenerator();
        for (int i = 0; i < newGenes.length; ++i) {
            newGenes[i] = sampleGenes[i].newGene();
            newGenes[i].setToRandomValue(generator);
        }
        return new ChromosomeForTesting(this.getConfiguration(), newGenes);
    }

    public synchronized Object clone() {
        try {
            ChromosomeForTesting chrom = new ChromosomeForTesting(this.getConfiguration(), (Gene[])super.getGenes().clone());
            chrom.m_isCloned = true;
            return chrom;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public boolean isHandlerFor(Object a_obj, Class a_class) {
        return a_class == this.getClass();
    }

    public Object perform(Object a_obj, Class a_class, Object a_params) throws Exception {
        return this.randomInitialChromosome2();
    }

    public static class TestResultHolder {
        static int computedTimes;
    }
}

