/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.WekaEnumeration;

public class ItemSet
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 2724000045282835791L;
    protected int[] m_items;
    protected int m_counter;
    protected int m_totalTransactions;

    public ItemSet(int totalTrans) {
        this.m_totalTransactions = totalTrans;
    }

    public ItemSet(int totalTrans, int[] array) {
        this.m_totalTransactions = totalTrans;
        this.m_items = array;
        this.m_counter = 1;
    }

    public ItemSet(int[] array) {
        this.m_items = array;
        this.m_counter = 0;
    }

    public boolean containedByTreatZeroAsMissing(Instance instance) {
        if (instance instanceof SparseInstance) {
            int numInstVals = instance.numValues();
            int numItemSetVals = this.m_items.length;
            int p1 = 0;
            int p2 = 0;
            while (p1 < numInstVals || p2 < numItemSetVals) {
                int itemIndex;
                int instIndex = Integer.MAX_VALUE;
                if (p1 < numInstVals) {
                    instIndex = instance.index(p1);
                }
                if (this.m_items[itemIndex = p2++] > -1) {
                    if (itemIndex != instIndex) {
                        return false;
                    }
                    if (instance.isMissingSparse(p1)) {
                        return false;
                    }
                    if (this.m_items[itemIndex] != (int)instance.valueSparse(p1)) {
                        return false;
                    }
                    ++p1;
                    continue;
                }
                if (itemIndex < instIndex) {
                    ++p2;
                    continue;
                }
                if (itemIndex != instIndex) continue;
                ++p2;
                ++p1;
            }
        } else {
            int i = 0;
            while (i < instance.numAttributes()) {
                if (this.m_items[i] > -1) {
                    if (instance.isMissing(i) || (int)instance.value(i) == 0) {
                        return false;
                    }
                    if (this.m_items[i] != (int)instance.value(i)) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public boolean containedBy(Instance instance) {
        int i = 0;
        while (i < instance.numAttributes()) {
            if (this.m_items[i] > -1) {
                if (instance.isMissing(i)) {
                    return false;
                }
                if (this.m_items[i] != (int)instance.value(i)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static ArrayList<Object> deleteItemSets(ArrayList<Object> itemSets, int minSupport, int maxSupport) {
        ArrayList<Object> newVector = new ArrayList<Object>(itemSets.size());
        int i = 0;
        while (i < itemSets.size()) {
            ItemSet current = (ItemSet)itemSets.get(i);
            if (current.m_counter >= minSupport && current.m_counter <= maxSupport) {
                newVector.add(current);
            }
            ++i;
        }
        return newVector;
    }

    public boolean equals(Object itemSet) {
        if (itemSet == null || !itemSet.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.m_items.length != ((ItemSet)itemSet).m_items.length) {
            return false;
        }
        int i = 0;
        while (i < this.m_items.length) {
            if (this.m_items[i] != ((ItemSet)itemSet).m_items[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Hashtable<ItemSet, Integer> getHashtable(ArrayList<Object> itemSets, int initialSize) {
        Hashtable<ItemSet, Integer> hashtable = new Hashtable<ItemSet, Integer>(initialSize);
        int i = 0;
        while (i < itemSets.size()) {
            ItemSet current = (ItemSet)itemSets.get(i);
            hashtable.put(current, new Integer(current.m_counter));
            ++i;
        }
        return hashtable;
    }

    public int hashCode() {
        long result = 0L;
        int i = this.m_items.length - 1;
        while (i >= 0) {
            result += (long)(i * this.m_items[i]);
            --i;
        }
        return (int)result;
    }

    public static ArrayList<Object> mergeAllItemSets(ArrayList<Object> itemSets, int size, int totalTrans) {
        ArrayList<Object> newVector = new ArrayList<Object>();
        int i = 0;
        while (i < itemSets.size()) {
            ItemSet first = (ItemSet)itemSets.get(i);
            int j = i + 1;
            block1: while (j < itemSets.size()) {
                ItemSet second = (ItemSet)itemSets.get(j);
                ItemSet result = new ItemSet(totalTrans);
                result.m_items = new int[first.m_items.length];
                int numFound = 0;
                int k = 0;
                while (numFound < size) {
                    if (first.m_items[k] != second.m_items[k]) break block1;
                    if (first.m_items[k] != -1) {
                        ++numFound;
                    }
                    result.m_items[k] = first.m_items[k];
                    ++k;
                }
                while (k < first.m_items.length) {
                    if (first.m_items[k] != -1 && second.m_items[k] != -1) break;
                    result.m_items[k] = first.m_items[k] != -1 ? first.m_items[k] : second.m_items[k];
                    ++k;
                }
                if (k == first.m_items.length) {
                    result.m_counter = 0;
                    newVector.add(result);
                }
                ++j;
            }
            ++i;
        }
        return newVector;
    }

    public static ArrayList<Object> pruneItemSets(ArrayList<Object> toPrune, Hashtable<ItemSet, Integer> kMinusOne) {
        ArrayList<Object> newVector = new ArrayList<Object>(toPrune.size());
        int i = 0;
        while (i < toPrune.size()) {
            ItemSet current = (ItemSet)toPrune.get(i);
            int j = 0;
            while (j < current.m_items.length) {
                if (current.m_items[j] != -1) {
                    int help = current.m_items[j];
                    current.m_items[j] = -1;
                    if (kMinusOne.get(current) == null) {
                        current.m_items[j] = help;
                        break;
                    }
                    current.m_items[j] = help;
                }
                ++j;
            }
            if (j == current.m_items.length) {
                newVector.add(current);
            }
            ++i;
        }
        return newVector;
    }

    public static void pruneRules(ArrayList<Object>[] rules, double minConfidence) {
        ArrayList<Object> newPremises = new ArrayList<Object>(rules[0].size());
        ArrayList<Object> newConsequences = new ArrayList<Object>(rules[1].size());
        ArrayList<Object> newConf = new ArrayList<Object>(rules[2].size());
        ArrayList<Object> newLift = null;
        ArrayList<Object> newLev = null;
        ArrayList<Object> newConv = null;
        if (rules.length > 3) {
            newLift = new ArrayList<Object>(rules[3].size());
            newLev = new ArrayList<Object>(rules[4].size());
            newConv = new ArrayList<Object>(rules[5].size());
        }
        int i = 0;
        while (i < rules[0].size()) {
            if (!((Double)rules[2].get(i) < minConfidence)) {
                newPremises.add(rules[0].get(i));
                newConsequences.add(rules[1].get(i));
                newConf.add(rules[2].get(i));
                if (rules.length > 3) {
                    newLift.add(rules[3].get(i));
                    newLev.add(rules[4].get(i));
                    newConv.add(rules[5].get(i));
                }
            }
            ++i;
        }
        rules[0] = newPremises;
        rules[1] = newConsequences;
        rules[2] = newConf;
        if (rules.length > 3) {
            rules[3] = newLift;
            rules[4] = newLev;
            rules[5] = newConv;
        }
    }

    public static ArrayList<Object> singletons(Instances instances) throws Exception {
        ArrayList<Object> setOfItemSets = new ArrayList<Object>();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int j = 0;
            while (j < instances.attribute(i).numValues()) {
                ItemSet current = new ItemSet(instances.numInstances());
                current.m_items = new int[instances.numAttributes()];
                int k = 0;
                while (k < instances.numAttributes()) {
                    current.m_items[k] = -1;
                    ++k;
                }
                current.m_items[i] = j++;
                setOfItemSets.add(current);
            }
            ++i;
        }
        return setOfItemSets;
    }

    public int support() {
        return this.m_counter;
    }

    public String toString(Instances instances) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (this.m_items[i] != -1) {
                text.append(String.valueOf(instances.attribute(i).name()) + '=');
                text.append(String.valueOf(instances.attribute(i).value(this.m_items[i])) + ' ');
            }
            ++i;
        }
        text.append(this.m_counter);
        return text.toString();
    }

    public String toString(Instances instances, char outerDelim, char innerDelim) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (this.m_items[i] != -1) {
                text.append(instances.attribute(i).name()).append('=').append(instances.attribute(i).value(this.m_items[i])).append(innerDelim);
            }
            ++i;
        }
        int n = text.length();
        if (n > 0) {
            text.setCharAt(n - 1, outerDelim);
        } else if (outerDelim != ' ' || innerDelim != ' ') {
            text.append(outerDelim);
        }
        text.append(this.m_counter);
        return text.toString();
    }

    public void upDateCounter(Instance instance) {
        if (this.containedBy(instance)) {
            ++this.m_counter;
        }
    }

    public void updateCounterTreatZeroAsMissing(Instance instance) {
        if (this.containedByTreatZeroAsMissing(instance)) {
            ++this.m_counter;
        }
    }

    public static void upDateCounters(ArrayList<Object> itemSets, Instances instances) {
        int i = 0;
        while (i < instances.numInstances()) {
            WekaEnumeration<Object> enu = new WekaEnumeration<Object>(itemSets);
            while (enu.hasMoreElements()) {
                ((ItemSet)enu.nextElement()).upDateCounter(instances.instance(i));
            }
            ++i;
        }
    }

    public static void upDateCountersTreatZeroAsMissing(ArrayList<Object> itemSets, Instances instances) {
        int i = 0;
        while (i < instances.numInstances()) {
            WekaEnumeration<Object> enu = new WekaEnumeration<Object>(itemSets);
            while (enu.hasMoreElements()) {
                ((ItemSet)enu.nextElement()).updateCounterTreatZeroAsMissing(instances.instance(i));
            }
            ++i;
        }
    }

    public int counter() {
        return this.m_counter;
    }

    public int[] items() {
        return this.m_items;
    }

    public int itemAt(int k) {
        return this.m_items[k];
    }

    public void setCounter(int count) {
        this.m_counter = count;
    }

    public void setItem(int[] items) {
        this.m_items = items;
    }

    public void setItemAt(int value, int k) {
        this.m_items[k] = value;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

