/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.scores.AveragePrecisionEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.MaximumF1Evaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.PrecisionAtKEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DBIDsTest;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.OutlierScoreAdapter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.SimpleAdapter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierRankingEvaluation
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(OutlierRankingEvaluation.class);
    private Pattern positiveClassName;
    private String key = OutlierRankingEvaluation.class.getName();

    public OutlierRankingEvaluation(Pattern pattern) {
        this.positiveClassName = pattern;
    }

    private EvaluationResult evaluateOutlierResult(int n, SetDBIDs setDBIDs, OutlierResult outlierResult) {
        EvaluationResult evaluationResult = new EvaluationResult("Evaluation of ranking", "ranking-evaluation");
        DBIDsTest dBIDsTest = new DBIDsTest(setDBIDs);
        double d = (double)setDBIDs.size() / (double)n;
        EvaluationResult.MeasurementGroup measurementGroup = evaluationResult.newGroup("Evaluation measures:");
        double d2 = ROCEvaluation.STATIC.evaluate(dBIDsTest, new OutlierScoreAdapter(outlierResult));
        measurementGroup.addMeasure("ROC AUC", d2, 0.0, 1.0, 0.5, false);
        double d3 = AveragePrecisionEvaluation.STATIC.evaluate(dBIDsTest, new OutlierScoreAdapter(outlierResult));
        measurementGroup.addMeasure("Average Precision", d3, 0.0, 1.0, d, false);
        double d4 = PrecisionAtKEvaluation.RPRECISION.evaluate(dBIDsTest, new OutlierScoreAdapter(outlierResult));
        measurementGroup.addMeasure("R-Precision", d4, 0.0, 1.0, d, false);
        double d5 = MaximumF1Evaluation.STATIC.evaluate(dBIDsTest, new OutlierScoreAdapter(outlierResult));
        measurementGroup.addMeasure("Maximum F1", d5, 0.0, 1.0, d, false);
        measurementGroup = evaluationResult.newGroup("Adjusted for chance:");
        double d6 = 2.0 * d2 - 1.0;
        measurementGroup.addMeasure("Adjusted AUC", d6, 0.0, 1.0, 0.0, false);
        double d7 = (d3 - d) / (1.0 - d);
        measurementGroup.addMeasure("Adjusted AveP", d7, 0.0, 1.0, 0.0, false);
        double d8 = (d4 - d) / (1.0 - d);
        measurementGroup.addMeasure("Adjusted R-Prec", d8, 0.0, 1.0, 0.0, false);
        double d9 = (d5 - d) / (1.0 - d);
        measurementGroup.addMeasure("Adjusted Max F1", d9, 0.0, 1.0, 0.0, false);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc", d2));
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc.adjusted", d6));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average", d3));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average.adjusted", d7));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r", d4));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r.adjusted", d8));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum", d5));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum.adjusted", d9));
        }
        return evaluationResult;
    }

    private EvaluationResult evaluateOrderingResult(int n, SetDBIDs setDBIDs, DBIDs dBIDs) {
        if (dBIDs.size() != n) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        EvaluationResult evaluationResult = new EvaluationResult("Evaluation of ranking", "ranking-evaluation");
        DBIDsTest dBIDsTest = new DBIDsTest(setDBIDs);
        double d = (double)setDBIDs.size() / (double)n;
        EvaluationResult.MeasurementGroup measurementGroup = evaluationResult.newGroup("Evaluation measures:");
        double d2 = ROCEvaluation.STATIC.evaluate(dBIDsTest, new SimpleAdapter(dBIDs.iter()));
        measurementGroup.addMeasure("ROC AUC", d2, 0.0, 1.0, 0.5, false);
        double d3 = AveragePrecisionEvaluation.STATIC.evaluate(dBIDsTest, new SimpleAdapter(dBIDs.iter()));
        measurementGroup.addMeasure("Average Precision", d3, 0.0, 1.0, d, false);
        double d4 = PrecisionAtKEvaluation.RPRECISION.evaluate(dBIDsTest, new SimpleAdapter(dBIDs.iter()));
        measurementGroup.addMeasure("R-Precision", d4, 0.0, 1.0, d, false);
        double d5 = MaximumF1Evaluation.STATIC.evaluate(dBIDsTest, new SimpleAdapter(dBIDs.iter()));
        measurementGroup.addMeasure("Maximum F1", d5, 0.0, 1.0, d, false);
        measurementGroup = evaluationResult.newGroup("Adjusted for chance:");
        double d6 = 2.0 * d2 - 1.0;
        measurementGroup.addMeasure("Adjusted AUC", d6, 0.0, 1.0, 0.0, false);
        double d7 = (d3 - d) / (1.0 - d);
        measurementGroup.addMeasure("Adjusted AveP", d7, 0.0, 1.0, 0.0, false);
        double d8 = (d4 - d) / (1.0 - d);
        measurementGroup.addMeasure("Adjusted R-Prec", d8, 0.0, 1.0, 0.0, false);
        double d9 = (d5 - d) / (1.0 - d);
        measurementGroup.addMeasure("Adjusted Max F1", d9, 0.0, 1.0, 0.0, false);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc", d2));
            LOG.statistics(new DoubleStatistic(this.key + ".rocauc.adjusted", d6));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average", d3));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.average.adjusted", d7));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r", d4));
            LOG.statistics(new DoubleStatistic(this.key + ".precision.r.adjusted", d8));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum", d5));
            LOG.statistics(new DoubleStatistic(this.key + ".f1.maximum.adjusted", d9));
        }
        return evaluationResult;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Database database = ResultUtil.findDatabase(resultHierarchy);
        SetDBIDs setDBIDs = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName));
        if (setDBIDs.size() == 0) {
            LOG.warning("Cannot evaluate outlier results - no objects matched the given pattern.");
            return;
        }
        boolean bl = true;
        List<OutlierResult> list = ResultUtil.getOutlierResults(result);
        List<OrderingResult> list2 = ResultUtil.getOrderingResults(result);
        for (OutlierResult result2 : list) {
            database.getHierarchy().add(result2, this.evaluateOutlierResult(result2.getScores().size(), setDBIDs, result2));
            list2.remove(result2.getOrdering());
            bl = false;
        }
        for (OrderingResult orderingResult : list2) {
            ArrayModifiableDBIDs arrayModifiableDBIDs = orderingResult.order(orderingResult.getDBIDs());
            database.getHierarchy().add(orderingResult, this.evaluateOrderingResult(orderingResult.getDBIDs().size(), setDBIDs, arrayModifiableDBIDs));
            bl = false;
        }
        if (bl) {
            return;
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("outliereval.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (parameterization.grab(patternParameter)) {
                this.positiveClassName = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected OutlierRankingEvaluation makeInstance() {
            return new OutlierRankingEvaluation(this.positiveClassName);
        }
    }
}

