/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.pairs;

import java.util.Comparator;

public class IntDoublePair
implements Comparable<IntDoublePair> {
    public int first;
    public double second;
    public static final Comparator<IntDoublePair> BYFIRST_COMPARATOR = new Comparator<IntDoublePair>(){

        @Override
        public int compare(IntDoublePair intDoublePair, IntDoublePair intDoublePair2) {
            return intDoublePair.first - intDoublePair2.first;
        }
    };
    public static final Comparator<IntDoublePair> BYSECOND_COMPARATOR = new Comparator<IntDoublePair>(){

        @Override
        public int compare(IntDoublePair intDoublePair, IntDoublePair intDoublePair2) {
            return Double.compare(intDoublePair.second, intDoublePair2.second);
        }
    };
    public static final Comparator<IntDoublePair> SWAPPED_COMPARATOR = new Comparator<IntDoublePair>(){

        @Override
        public int compare(IntDoublePair intDoublePair, IntDoublePair intDoublePair2) {
            return intDoublePair.compareSwappedTo(intDoublePair2);
        }
    };

    public IntDoublePair(int n, double d) {
        this.first = n;
        this.second = d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntDoublePair intDoublePair = (IntDoublePair)object;
        return this.first == intDoublePair.first && this.second == intDoublePair.second;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.second);
        l ^= l >> 32;
        return (int)((long)this.first * 2654435761L + l);
    }

    @Override
    public int compareTo(IntDoublePair intDoublePair) {
        int n = this.first - intDoublePair.first;
        if (n != 0) {
            return n;
        }
        return Double.compare(this.second, intDoublePair.second);
    }

    public int compareSwappedTo(IntDoublePair intDoublePair) {
        int n = Double.compare(this.second, intDoublePair.second);
        if (n != 0) {
            return n;
        }
        return this.first - intDoublePair.first;
    }

    public final void setFirst(int n) {
        this.first = n;
    }

    public final void setSecond(double d) {
        this.second = d;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }
}

