/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityIndicator;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.ErrorRatio;
import org.uma.jmetal.qualityindicator.impl.GeneralizedSpread;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.Hypervolume;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.R2;
import org.uma.jmetal.qualityindicator.impl.SetCoverage;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontNormalizer;
import org.uma.jmetal.util.front.util.FrontUtils;

public class CommandLineIndicatorRunner {
    public static void main(String[] args) throws Exception {
        CommandLineIndicatorRunner.checkArguments(args);
        boolean normalize = CommandLineIndicatorRunner.checkAboutNormalization(args);
        CommandLineIndicatorRunner.calculateAndPrintIndicators(args, normalize);
    }

    private static void checkArguments(String[] args) {
        if (args.length != 3 && args.length != 4) {
            CommandLineIndicatorRunner.printOptions();
            throw new JMetalException("Incorrect arguments");
        }
    }

    private static boolean checkAboutNormalization(String[] args) {
        boolean normalize = false;
        if (args.length == 4) {
            if (args[3].equals("TRUE")) {
                normalize = true;
            } else if (args[3].equals("FALSE")) {
                normalize = false;
            } else {
                throw new JMetalException("The value for normalizing must be TRUE or FALSE");
            }
        }
        return normalize;
    }

    private static void printOptions() {
        JMetalLogger.logger.info("Usage: mvn -pl jmetal-exec exec:java -Dexec:mainClass=\"org.uma.jmetal.qualityIndicator.RunIndicator\"-Dexec.args=\"indicatorName referenceFront front [normalize]\" \n\nWhere indicatorValue can be one of these:\nGD   - Generational distance\nIGD  - Inverted generational distance\nIGD  - Inverted generational distance\nIGD+ - Inverted generational distance plus \nHV   - Hypervolume \nER   - Error ratio \nSPREAD  - Spread (two objectives)\nGSPREAD - Generalized Spread (more than two objectives)\nER   - Error ratio\nR2   - R2\n\nALL  - prints all the available indicators \n\nNormalize can be TRUE or FALSE (the fronts are normalized before computing the indicators) \n");
    }

    private static void calculateAndPrintIndicators(String[] args, boolean normalize) throws FileNotFoundException {
        Front referenceFront = new ArrayFront(args[1]);
        Front front = new ArrayFront(args[2]);
        if (normalize) {
            referenceFront = new FrontNormalizer(referenceFront).normalize(referenceFront);
            front = new FrontNormalizer(referenceFront).normalize(front);
            System.out.println("The fronts are NORMALIZED before computing the indicators");
        } else {
            System.out.println("The fronts are NOT NORMALIZED before computing the indicators");
        }
        List<QualityIndicator<List<Solution<?>>, Double>> indicatorList = CommandLineIndicatorRunner.getAvailableIndicators(referenceFront, normalize);
        if (!args[0].equals("ALL")) {
            QualityIndicator<List<Solution<?>>, Double> indicator = CommandLineIndicatorRunner.getIndicatorFromName(args[0], indicatorList);
            System.out.println(indicator.evaluate(FrontUtils.convertFrontToSolutionList(front)));
        } else {
            for (QualityIndicator<List<Solution<?>>, Double> indicator : indicatorList) {
                System.out.println(indicator.getName() + ": " + indicator.evaluate(FrontUtils.convertFrontToSolutionList(front)));
            }
            SetCoverage sc = new SetCoverage();
            System.out.println("SC(refPF, front): " + sc.evaluate(FrontUtils.convertFrontToSolutionList(referenceFront), FrontUtils.convertFrontToSolutionList(front)));
            System.out.println("SC(front, refPF): " + sc.evaluate(FrontUtils.convertFrontToSolutionList(front), FrontUtils.convertFrontToSolutionList(referenceFront)));
        }
    }

    private static List<QualityIndicator<List<? extends Solution<?>>, Double>> getAvailableIndicators(Front referenceFront, boolean normalize) throws FileNotFoundException {
        ArrayList list = new ArrayList();
        list.add(new Epsilon(referenceFront));
        list.add(new Hypervolume(referenceFront));
        list.add(new GenerationalDistance(referenceFront));
        list.add(new InvertedGenerationalDistance(referenceFront));
        list.add(new InvertedGenerationalDistancePlus(referenceFront));
        list.add(new Spread(referenceFront));
        list.add(new GeneralizedSpread(referenceFront));
        list.add(new R2(referenceFront));
        list.add(new ErrorRatio(referenceFront));
        return list;
    }

    private static QualityIndicator<List<? extends Solution<?>>, Double> getIndicatorFromName(String name, List<QualityIndicator<List<? extends Solution<?>>, Double>> list) {
        QualityIndicator<List<Solution<?>>, Double> result = null;
        for (QualityIndicator<List<Solution<?>>, Double> indicator : list) {
            if (!indicator.getName().equals(name)) continue;
            result = indicator;
        }
        if (result == null) {
            throw new JMetalException("Indicator " + name + " not available");
        }
        return result;
    }
}

