/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock;

import org.eclipse.epsilon.flock.FlockResult;
import org.eclipse.epsilon.flock.IFlockContext;
import org.eclipse.epsilon.flock.MigrationStrategyRunner;
import org.eclipse.epsilon.flock.emc.wrappers.Model;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.MigrationStrategy;

public class FlockExecution {
    private final MigrationStrategyRunner runner;
    private final FlockResult result = new FlockResult();

    public FlockExecution(IFlockContext context, MigrationStrategy strategy) {
        this(new MigrationStrategyRunner(context, strategy));
    }

    public FlockExecution(MigrationStrategyRunner runner) {
        this.runner = runner;
    }

    public FlockResult run(Model originalModel) throws FlockRuntimeException {
        this.ensureExpandIsOff(originalModel);
        this.runner.run();
        return this.result;
    }

    private void ensureExpandIsOff(Model originalModel) {
        if (originalModel.preventLoadingOfExternalModelElements()) {
            this.addWarning("Flock can produce unexpected results when the original model includes references to other models. Flock is ignoring these external references in your original model and proceeding.");
        }
    }

    public void addWarning(String warning) {
        this.result.addWarning(warning);
    }

    public ModelElement getEquivalent(ModelElement originalModelElement) {
        return this.runner.getEquivalent(originalModelElement);
    }
}

