/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.equivalences;

import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.flock.FlockExecution;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.emc.wrappers.ModelValue;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.execution.EolExecutor;
import org.eclipse.epsilon.flock.execution.exceptions.ConservativeCopyException;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.rules.IgnoredProperties;

public class TypeBasedEquivalence
extends Equivalence {
    protected final ModelElement original;
    protected final ModelElement equivalent;

    public TypeBasedEquivalence(EolExecutor executor, FlockExecution execution, ModelElement original, ModelElement equivalent) {
        super(executor, execution);
        this.original = original;
        this.equivalent = equivalent;
    }

    @Override
    public ModelElement getOriginal() {
        return this.original;
    }

    @Override
    public ModelElement getEquivalent() {
        return this.equivalent;
    }

    @Override
    public void ruleApplied(FlockExecution execution) {
    }

    @Override
    public void automaticallyPopulateEquivalent(ConservativeCopyContext context, IgnoredProperties ignoredProperties) throws FlockRuntimeException {
        this.equivalent.copyIdentityFrom(this.original);
        this.conservativeCopy(context, ignoredProperties);
    }

    private void conservativeCopy(ConservativeCopyContext context, IgnoredProperties ignoredProperties) throws ConservativeCopyException {
        new ConservativeCopy(context, ignoredProperties).copyProperties(this.original, this.equivalent);
    }

    @Override
    public String toString() {
        return this.original + " <-> " + this.equivalent;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TypeBasedEquivalence)) {
            return false;
        }
        TypeBasedEquivalence other = (TypeBasedEquivalence)obj;
        return this.original.equals(other.original) && this.equivalent.equals(other.equivalent);
    }

    @Override
    public int hashCode() {
        return this.original.hashCode() + this.equivalent.hashCode();
    }

    public static class ConservativeCopy {
        private final ConservativeCopyContext context;
        private final IgnoredProperties ignoredProperties;

        public ConservativeCopy(ConservativeCopyContext context) {
            this(context, new IgnoredProperties(new String[0]));
        }

        public ConservativeCopy(ConservativeCopyContext context, IgnoredProperties ignoredProperties) {
            this.context = context;
            this.ignoredProperties = ignoredProperties;
        }

        public void copyProperties(ModelElement original, ModelElement equivalent) throws ConservativeCopyException {
            try {
                for (String propertyName : original.getPropertiesSharedWith(equivalent)) {
                    if (!this.ignoredProperties.isNotIgnored(propertyName)) continue;
                    this.copyProperty(propertyName, original, equivalent);
                }
            }
            catch (EolModelElementTypeNotFoundException e) {
                throw new ConservativeCopyException("Exception encountered while determining properties shared between " + original + " and " + this, e);
            }
        }

        void copyProperty(String propertyName, ModelElement original, ModelElement equivalent) throws ConservativeCopyException {
            try {
                ModelValue<?> equivalentValue = this.context.getEquivalentValue(original.getValueOfProperty(propertyName));
                equivalent.conservativelySetValueForProperty(equivalentValue, propertyName, this.context);
            }
            catch (EolRuntimeException e) {
                throw new ConservativeCopyException("Exception encountered while copying '" + propertyName + "' from " + original + " to " + this, e);
            }
        }
    }
}

