/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import java.util.Comparator;

public abstract class GeneralizedOPTICS<O, R extends ClusterOrder>
extends AbstractAlgorithm<R>
implements OPTICSTypeAlgorithm {
    public abstract ClusterOrder run(Database var1, Relation<O> var2);

    public static abstract class Instance<O, R>
    implements Comparator<DBIDRef> {
        protected ModifiableDBIDs processedIDs;
        protected ArrayModifiableDBIDs candidates;
        protected WritableDBIDDataStore predecessor;
        protected WritableDoubleDataStore reachability;
        DBIDs ids;
        FiniteProgress progress;

        public Instance(Database database, Relation<O> relation) {
            this.ids = relation.getDBIDs();
            this.processedIDs = DBIDUtil.newHashSet(this.ids.size());
            this.candidates = DBIDUtil.newArray();
            this.predecessor = DataStoreUtil.makeDBIDStorage(this.ids, 2);
            this.reachability = DataStoreUtil.makeDoubleStorage(this.ids, 30, Double.POSITIVE_INFINITY);
            this.progress = this.getLogger().isVerbose() ? new FiniteProgress("OPTICS", this.ids.size(), this.getLogger()) : null;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            return Double.compare(this.reachability.doubleValue(dBIDRef2), this.reachability.doubleValue(dBIDRef));
        }

        public R run() {
            Logging logging = this.getLogger();
            DBIDVar dBIDVar = DBIDUtil.newVar();
            DBIDIter dBIDIter = this.ids.iter();
            while (dBIDIter.valid()) {
                if (!this.processedIDs.contains(dBIDIter)) {
                    this.initialDBID(dBIDIter);
                    this.processedIDs.add(dBIDIter);
                    this.expandDBID(dBIDIter);
                    logging.incrementProcessed(this.progress);
                    while (!this.candidates.isEmpty()) {
                        int n = this.candidates.size() - 1;
                        QuickSelect.quickSelect(this.candidates, this, n);
                        this.candidates.assignVar(n, dBIDVar);
                        this.candidates.remove(n);
                        this.processedIDs.add(dBIDVar);
                        this.expandDBID(dBIDVar);
                        logging.incrementProcessed(this.progress);
                    }
                }
                dBIDIter.advance();
            }
            logging.ensureCompleted(this.progress);
            return this.buildResult();
        }

        protected abstract void initialDBID(DBIDRef var1);

        protected abstract void expandDBID(DBIDRef var1);

        protected abstract R buildResult();

        protected abstract Logging getLogger();
    }
}

