/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="E. Schubert, A. Zimek, H.-P. Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery, 28(1): 190\u2013237, 2014.", url="http://dx.doi.org/10.1007/s10618-012-0300-z")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.SimpleLOF"})
public class SimplifiedLOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimplifiedLOF.class);
    protected int k;

    public SimplifiedLOF(int n, DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
        this.k = n + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("Simplified LOF", 3) : null;
        DBIDs dBIDs = relation.getDBIDs();
        LOG.beginStep(stepProgress, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepProgress, 2, "Computing densities.");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        this.computeSimplifiedLRDs(dBIDs, kNNQuery, writableDoubleDataStore);
        LOG.beginStep(stepProgress, 3, "Computing SLOFs.");
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        this.computeSimplifiedLOFs(dBIDs, kNNQuery, writableDoubleDataStore, writableDoubleDataStore2, doubleMinMax);
        LOG.setCompleted(stepProgress);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Simplified Local Outlier Factor", "simplified-lof-outlier", writableDoubleDataStore2, dBIDs);
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult outlierResult = new OutlierResult(quotientOutlierScoreMeta, materializedDoubleRelation);
        return outlierResult;
    }

    private void computeSimplifiedLRDs(DBIDs dBIDs, KNNQuery<O> kNNQuery, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Densities", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            double d = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                    d += doubleDBIDListIter.doubleValue();
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            double d2 = d > 0.0 ? (double)n / d : Double.POSITIVE_INFINITY;
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    private void computeSimplifiedLOFs(DBIDs dBIDs, KNNQuery<O> kNNQuery, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2, DoubleMinMax doubleMinMax) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Simplified LOF scores", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d;
            double d2 = writableDoubleDataStore.doubleValue(dBIDIter);
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            if (!Double.isInfinite(d2)) {
                double d3 = 0.0;
                int n = 0;
                DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
                while (doubleDBIDListIter.valid()) {
                    if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                        double d4 = writableDoubleDataStore.doubleValue(doubleDBIDListIter);
                        d3 += d4;
                        ++n;
                        if (Double.isInfinite(d4)) break;
                    }
                    doubleDBIDListIter.advance();
                }
                d = d3 / (d2 * (double)n);
            } else {
                d = 1.0;
            }
            writableDoubleDataStore2.putDouble(dBIDIter, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        protected int k = 2;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(LOF.Parameterizer.K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected SimplifiedLOF<O> makeInstance() {
            return new SimplifiedLOF(this.k, this.distanceFunction);
        }
    }
}

