/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.DistanceEntry;
import java.util.ArrayList;
import java.util.List;

public class Assignments<E extends MTreeEntry> {
    private DBID id1;
    private DBID id2;
    private List<DistanceEntry<E>> firstAssignments;
    private List<DistanceEntry<E>> secondAssignments;

    public Assignments(DBID dBID, DBID dBID2, int n) {
        this.id1 = dBID;
        this.id2 = dBID2;
        this.firstAssignments = new ArrayList<DistanceEntry<E>>(n);
        this.secondAssignments = new ArrayList<DistanceEntry<E>>(n);
    }

    public Assignments(int n) {
        this.id1 = null;
        this.id2 = null;
        this.firstAssignments = new ArrayList<DistanceEntry<E>>(n);
        this.secondAssignments = new ArrayList<DistanceEntry<E>>(n);
    }

    public void addToFirst(E e, double d, int n) {
        this.firstAssignments.add(new DistanceEntry<E>(e, d, n));
    }

    public double computeFirstCover(boolean bl) {
        double d = 0.0;
        for (DistanceEntry<E> distanceEntry : this.firstAssignments) {
            double d2 = bl ? distanceEntry.getDistance() : ((MTreeEntry)distanceEntry.getEntry()).getCoveringRadius() + distanceEntry.getDistance();
            d = d2 > d ? d2 : d;
        }
        return d;
    }

    public double computeSecondCover(boolean bl) {
        double d = 0.0;
        for (DistanceEntry<E> distanceEntry : this.secondAssignments) {
            double d2 = bl ? distanceEntry.getDistance() : ((MTreeEntry)distanceEntry.getEntry()).getCoveringRadius() + distanceEntry.getDistance();
            d = d2 > d ? d2 : d;
        }
        return d;
    }

    public void addToSecond(E e, double d, int n) {
        this.secondAssignments.add(new DistanceEntry<E>(e, d, n));
    }

    public DBID getFirstRoutingObject() {
        return this.id1;
    }

    public DBID getSecondRoutingObject() {
        return this.id2;
    }

    public List<DistanceEntry<E>> getFirstAssignments() {
        return this.firstAssignments;
    }

    public List<DistanceEntry<E>> getSecondAssignments() {
        return this.secondAssignments;
    }

    public void setFirstRoutingObject(DBID dBID) {
        this.id1 = dBID;
    }

    public void setSecondRoutingObject(DBID dBID) {
        this.id2 = dBID;
    }
}

