/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="R. Huisman and K. G. Koedijk and C. J. M. Kool and F. Palm", title="Tail-Index Estimates in Small Samples", booktitle="Journal of Business & Economic Statistics", url="http://dx.doi.org/10.1198/073500101316970421")
public class AggregatedHillEstimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final AggregatedHillEstimator STATIC = new AggregatedHillEstimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        double d = 0.0;
        double d2 = Math.log(numberArrayAdapter.getDouble(a, 0));
        for (int i = 1; i < n; ++i) {
            double d3 = numberArrayAdapter.getDouble(a, i);
            assert (d3 > 0.0);
            double d4 = Math.log(d3);
            d += d2 / (double)i - d4;
            d2 += d4;
        }
        return (double)(-n) / d;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AggregatedHillEstimator makeInstance() {
            return STATIC;
        }
    }
}

