/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.actions;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;

public class ClusterStyleAction
extends AbstractVisFactory {
    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<Clustering> iter = VisualizationTree.filterResults(visualizerContext, object, Clustering.class);
        while (iter.valid()) {
            Clustering clustering = iter.get();
            Hierarchy.Iter<SetStyleAction> iter2 = VisualizationTree.filter(visualizerContext, clustering, SetStyleAction.class);
            if (!iter2.valid()) {
                visualizerContext.addVis(clustering, new SetStyleAction(clustering, visualizerContext));
            }
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        throw new AbortException("Should never be called.");
    }

    private static final class SetStyleAction
    implements VisualizationMenuAction {
        private final Clustering<?> c;
        private final VisualizerContext context;

        private SetStyleAction(Clustering<?> clustering, VisualizerContext visualizerContext) {
            this.c = clustering;
            this.context = visualizerContext;
        }

        @Override
        public void activate() {
            this.context.setStylingPolicy(new ClusterStylingPolicy(this.c, this.context.getStyleLibrary()));
        }

        @Override
        public String getMenuName() {
            return "Use as Styling Policy";
        }

        @Override
        public boolean enabled() {
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return true;
            }
            return ((ClusterStylingPolicy)stylingPolicy).getClustering() != this.c;
        }
    }
}

