/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LineVisualization
extends AbstractVisFactory {
    public static final String NAME = "Data lines";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            Relation relation = parallelPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, parallelPlotProjector.getRelation(), parallelPlotProjector.getRelation(), this);
                visualizationTask.level = 100;
                visualizationTask.addUpdateFlags(13);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        public static final String DATALINE = "Dataline";
        private SamplingResult sample;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.sample = ResultUtil.getSamplingResult(this.relation);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            DBIDs dBIDs = this.sample.getSample();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            LineStyleLibrary lineStyleLibrary = styleLibrary.lines();
            double d = styleLibrary.getLineWidth("plot") * MathUtil.min(0.5, 2.0 / MathUtil.log2(dBIDs.size()));
            if (stylingPolicy instanceof ClassStylingPolicy) {
                Object object;
                ClassStylingPolicy classStylingPolicy = (ClassStylingPolicy)stylingPolicy;
                int n = classStylingPolicy.getMinStyle();
                String[] stringArray = new String[classStylingPolicy.getMaxStyle() - n];
                for (int i = n; i < classStylingPolicy.getMaxStyle(); ++i) {
                    String string = "Dataline_" + i;
                    stringArray[i - n] = string;
                    String string2 = string;
                    if (this.svgp.getCSSClassManager().contains(string2)) continue;
                    object = new CSSClass(this, string2);
                    ((CSSClass)object).setStatement("stroke-linecap", "round");
                    ((CSSClass)object).setStatement("stroke-linejoin", "round");
                    ((CSSClass)object).setStatement("fill", "none");
                    lineStyleLibrary.formatCSSClass((CSSClass)object, i, d, new Object[0]);
                    this.svgp.addCSSClassOrLogError((CSSClass)object);
                }
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    int n2 = classStylingPolicy.getStyleForDBID(dBIDIter) + n;
                    if (n2 >= 0 && (object = this.drawLine(dBIDIter)) != null) {
                        SVGUtil.addCSSClass((Element)object, stringArray[n2]);
                        this.layer.appendChild((Node)object);
                    }
                    dBIDIter.advance();
                }
            } else {
                Object object;
                if (!this.svgp.getCSSClassManager().contains(DATALINE)) {
                    object = new CSSClass(this, DATALINE);
                    ((CSSClass)object).setStatement("stroke-linecap", "round");
                    ((CSSClass)object).setStatement("stroke-linejoin", "round");
                    ((CSSClass)object).setStatement("fill", "none");
                    lineStyleLibrary.formatCSSClass((CSSClass)object, -1, d, new Object[0]);
                    this.svgp.addCSSClassOrLogError((CSSClass)object);
                }
                object = new StringBuilder().append("stroke").append(':');
                int n = ((StringBuilder)object).length();
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    Element element = this.drawLine(dBIDIter);
                    if (element != null) {
                        SVGUtil.addCSSClass(element, DATALINE);
                        ((StringBuilder)object).delete(n, ((StringBuilder)object).length());
                        ((StringBuilder)object).append(SVGUtil.colorToString(stylingPolicy.getColorForDBID(dBIDIter)));
                        element.setAttribute("style", ((StringBuilder)object).toString());
                        this.layer.appendChild(element);
                    }
                    dBIDIter.advance();
                }
            }
            this.svgp.updateStyleElement();
        }

        private Element drawLine(DBIDRef dBIDRef) {
            SVGPath sVGPath = new SVGPath();
            double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(dBIDRef));
            boolean bl = false;
            int n = 0;
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] != dArray[i]) {
                    n = 0;
                    continue;
                }
                if (++n <= 1) continue;
                if (n == 2) {
                    sVGPath.moveTo(this.getVisibleAxisX(i - 1), dArray[i - 1]);
                }
                sVGPath.lineTo(this.getVisibleAxisX(i), dArray[i]);
                bl = true;
            }
            if (!bl) {
                return null;
            }
            return sVGPath.makeElement(this.svgp);
        }
    }
}

