/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util;

import de.ugoe.cs.util.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class FileTools {
    private FileTools() {
    }

    public static String[] getLinesFromFile(String filename) throws IOException, FileNotFoundException {
        boolean carriageReturn = true;
        if (StringTools.ENDLINE.equals("\n")) {
            carriageReturn = false;
        }
        return FileTools.getLinesFromFile(filename, carriageReturn);
    }

    public static String[] getLinesFromFile(String filename, boolean carriageReturn) throws IOException, FileNotFoundException {
        File f = new File(filename);
        FileInputStream fis = new FileInputStream(f);
        InputStreamReader reader = new InputStreamReader((InputStream)fis, Charset.defaultCharset());
        char[] buffer = new char[(int)f.length()];
        reader.read(buffer);
        reader.close();
        String splitString = carriageReturn ? "\r\n" : "\n";
        return new String(buffer).split(splitString);
    }

    public static String autoCompletePath(String prefix) {
        String completedPrefix;
        File completedFile;
        File prefixFile = new File(prefix);
        File parentDir = prefixFile.getParentFile();
        if (parentDir == null) {
            return prefix;
        }
        String[] completions = null;
        if (parentDir.exists()) {
            completions = parentDir.list();
        }
        if (completions == null) {
            completions = new String[]{};
        }
        if ((completedFile = new File(parentDir, completedPrefix = StringTools.autocomplete(prefixFile.getName(), completions))).exists() && completedFile.isDirectory()) {
            return completedFile.getAbsolutePath() + File.separator;
        }
        return (parentDir.getAbsolutePath() + File.separator + completedPrefix).replaceAll("//", "/");
    }
}

