/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.transform.NumberVectorFeatureSelectionFilter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;
import java.util.BitSet;

public class NumericalFeatureSelection<V extends NumberVector>
implements Projection<V, V> {
    private int mindim;
    private NumberVector.Factory<V> factory;
    private int[] dims;

    public NumericalFeatureSelection(int[] nArray) {
        this.dims = nArray;
        int n = 0;
        for (int n2 : nArray) {
            n = n2 > n ? n2 : n;
        }
        this.mindim = n + 1;
    }

    public NumericalFeatureSelection(BitSet bitSet) {
        int n = bitSet.cardinality();
        this.dims = new int[n];
        int n2 = 0;
        int n3 = bitSet.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            this.dims[n4] = n3;
            n2 = n3 > n2 ? n3 : n2;
            n3 = bitSet.nextSetBit(n3 + 1);
            ++n4;
        }
        this.mindim = n2 + 1;
    }

    @Override
    public void initialize(SimpleTypeInformation<V> simpleTypeInformation) {
        VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
        this.factory = (NumberVector.Factory)vectorFieldTypeInformation.getFactory();
        if (vectorFieldTypeInformation.getDimensionality() < this.mindim) {
            throw new AbortException("Data does not have enough dimensions for this projection!");
        }
    }

    @Override
    public V project(V v) {
        double[] dArray = new double[this.dims.length];
        for (int i = 0; i < this.dims.length; ++i) {
            dArray[i] = v.doubleValue(this.dims[i]);
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation(this.factory, this.dims.length);
    }

    @Override
    public TypeInformation getInputDataTypeInformation() {
        return VectorTypeInformation.typeRequest(NumberVector.class, this.mindim, Integer.MAX_VALUE);
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        int[] dims;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntListParameter intListParameter = (IntListParameter)new IntListParameter(NumberVectorFeatureSelectionFilter.Parameterizer.SELECTED_ATTRIBUTES_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST);
            if (parameterization.grab(intListParameter)) {
                this.dims = (int[])intListParameter.getValue();
            }
        }

        @Override
        protected NumericalFeatureSelection<V> makeInstance() {
            return new NumericalFeatureSelection(this.dims);
        }
    }
}

