/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

@Reference(authors="O. Benjelloun, A. D. Sarma, A. Halevy, J. Widom", title="ULDBs: Databases with uncertainty and lineage", booktitle="Proc. of the 32nd international conference on Very Large Data Bases (VLDB)", url="http://www.vldb.org/conf/2006/p953-benjelloun.pdf")
public class WeightedDiscreteUncertainObject
extends AbstractUncertainObject
implements DiscreteUncertainObject {
    public static final FeatureVector.Factory<WeightedDiscreteUncertainObject, ?> FACTORY = new Factory();
    private DoubleVector[] samples;
    private double[] weights;

    public WeightedDiscreteUncertainObject(DoubleVector[] doubleVectorArray, double[] dArray) {
        if (doubleVectorArray.length == 0) {
            throw new AbortException("Discrete Uncertain Objects must have at least one point.");
        }
        double d = 0.0;
        for (double d2 : dArray) {
            if (!(d2 > 0.0) || !(d2 < 1.0)) {
                throw new IllegalArgumentException("Probabilities must be in ]0:1], but is " + d2);
            }
            d += d2;
        }
        if (!(d > 0.0) || !(d <= 1.0000001)) {
            throw new IllegalArgumentException("Probability totals must be in ]0:1], but total is " + d);
        }
        this.samples = doubleVectorArray;
        this.bounds = WeightedDiscreteUncertainObject.computeBounds(doubleVectorArray);
        this.weights = dArray;
    }

    @Override
    public DoubleVector drawSample(Random random) {
        double d;
        int n = this.weights.length;
        for (d = random.nextDouble(); --n >= 0 && d < this.weights[n]; d -= this.weights[n]) {
        }
        if (n < 0) {
            if (d < Double.MIN_NORMAL * (double)this.samples.length) {
                n = random.nextInt(this.samples.length);
            } else {
                return null;
            }
        }
        return this.samples[n];
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int n;
        int n2 = this.getDimensionality();
        double[] dArray = new double[n2];
        double d = 0.0;
        for (n = 0; n < this.samples.length; ++n) {
            DoubleVector doubleVector = this.samples[n];
            double d2 = this.weights[n];
            for (int i = 0; i < n2; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + doubleVector.doubleValue(i) * d2;
            }
            d += d2;
        }
        n = 0;
        while (n < n2) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / d;
        }
        return new DoubleVector(dArray);
    }

    @Override
    public int getNumberSamples() {
        return this.samples.length;
    }

    @Override
    public DoubleVector getSample(int n) {
        return this.samples[n];
    }

    @Override
    public double getWeight(int n) {
        return this.weights[n];
    }

    private static class Factory
    implements FeatureVector.Factory<WeightedDiscreteUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> WeightedDiscreteUncertainObject newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<WeightedDiscreteUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super WeightedDiscreteUncertainObject> getRestrictionClass() {
            return WeightedDiscreteUncertainObject.class;
        }
    }
}

