/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.database.AbstractDatabase;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DBIDView;
import de.lmu.ifi.dbs.elki.database.relation.ProxyView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import java.util.Arrays;

public class ProxyDatabase
extends AbstractDatabase {
    private static final Logging LOG = Logging.getLogger(ProxyDatabase.class);
    protected DBIDView idrep;

    public ProxyDatabase(DBIDs dBIDs) {
        this.idrep = new DBIDView(dBIDs);
        this.relations.add(this.idrep);
        this.addChildResult(this.idrep);
    }

    public ProxyDatabase(DBIDs dBIDs, Iterable<Relation<?>> iterable) {
        this.idrep = new DBIDView(dBIDs);
        this.relations.add(this.idrep);
        this.addChildResult(this.idrep);
        for (Relation<?> relation : iterable) {
            ProxyView proxyView = new ProxyView(dBIDs, relation);
            this.relations.add(proxyView);
            this.addChildResult(proxyView);
        }
    }

    public ProxyDatabase(DBIDs dBIDs, Relation<?> ... relationArray) {
        this(dBIDs, Arrays.asList(relationArray));
    }

    public ProxyDatabase(DBIDs dBIDs, Database database) {
        this(dBIDs, database.getRelations());
    }

    @Override
    public void initialize() {
    }

    public void addRelation(Relation<?> relation) {
        this.relations.add(relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public void setDBIDs(DBIDs dBIDs) {
        this.idrep.setDBIDs(dBIDs);
        for (Relation relation : this.relations) {
            if (!(relation instanceof ProxyView)) continue;
            ((ProxyView)relation).setDBIDs(this.idrep.getDBIDs());
        }
    }
}

