/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreFactory;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayDBIDStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayDoubleStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayIntegerStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayRecordStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDDBIDStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDDoubleStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDIntegerStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDRecordStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;

public class MemoryDataStoreFactory
implements DataStoreFactory {
    @Override
    public <T> WritableDataStore<T> makeStorage(DBIDs dBIDs, int n, Class<? super T> clazz) {
        if (Double.class.equals(clazz)) {
            return this.makeDoubleStorage(dBIDs, n);
        }
        if (Integer.class.equals(clazz)) {
            return this.makeIntegerStorage(dBIDs, n);
        }
        if (dBIDs instanceof DBIDRange) {
            DBIDRange dBIDRange = (DBIDRange)dBIDs;
            Object[] objectArray = new Object[dBIDRange.size()];
            return new ArrayStore(objectArray, dBIDRange);
        }
        return new MapIntegerDBIDStore(dBIDs.size());
    }

    @Override
    public WritableDBIDDataStore makeDBIDStorage(DBIDs dBIDs, int n) {
        if (dBIDs instanceof DBIDRange) {
            DBIDRange dBIDRange = (DBIDRange)dBIDs;
            return new ArrayDBIDStore(dBIDRange.size(), dBIDRange);
        }
        return new MapIntegerDBIDDBIDStore(dBIDs.size());
    }

    @Override
    public WritableDoubleDataStore makeDoubleStorage(DBIDs dBIDs, int n) {
        if (dBIDs instanceof DBIDRange) {
            DBIDRange dBIDRange = (DBIDRange)dBIDs;
            return new ArrayDoubleStore(dBIDRange.size(), dBIDRange);
        }
        return new MapIntegerDBIDDoubleStore(dBIDs.size());
    }

    @Override
    public WritableDoubleDataStore makeDoubleStorage(DBIDs dBIDs, int n, double d) {
        if (dBIDs instanceof DBIDRange) {
            DBIDRange dBIDRange = (DBIDRange)dBIDs;
            return new ArrayDoubleStore(dBIDRange.size(), dBIDRange, d);
        }
        return new MapIntegerDBIDDoubleStore(dBIDs.size(), d);
    }

    @Override
    public WritableIntegerDataStore makeIntegerStorage(DBIDs dBIDs, int n) {
        if (dBIDs instanceof DBIDRange) {
            DBIDRange dBIDRange = (DBIDRange)dBIDs;
            return new ArrayIntegerStore(dBIDRange.size(), dBIDRange);
        }
        return new MapIntegerDBIDIntegerStore(dBIDs.size());
    }

    @Override
    public WritableIntegerDataStore makeIntegerStorage(DBIDs dBIDs, int n, int n2) {
        if (dBIDs instanceof DBIDRange) {
            DBIDRange dBIDRange = (DBIDRange)dBIDs;
            return new ArrayIntegerStore(dBIDRange.size(), dBIDRange, n2);
        }
        return new MapIntegerDBIDIntegerStore(dBIDs.size(), n2);
    }

    @Override
    public WritableRecordStore makeRecordStorage(DBIDs dBIDs, int n, Class<?> ... classArray) {
        if (dBIDs instanceof DBIDRange) {
            DBIDRange dBIDRange = (DBIDRange)dBIDs;
            Object[][] objectArray = new Object[dBIDRange.size()][classArray.length];
            return new ArrayRecordStore(objectArray, dBIDRange);
        }
        return new MapIntegerDBIDRecordStore(dBIDs.size(), classArray.length);
    }
}

