/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.bundle;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformationSerializer;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class BundleWriter {
    private static final Logging LOG = Logging.getLogger(BundleWriter.class);
    private static final int INITIAL_BUFFER = 4096;
    public static final int MAGIC = -1475200238;

    public void writeBundleStream(BundleStreamSource bundleStreamSource, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        ByteBufferSerializer<?>[] byteBufferSerializerArray = null;
        block5: while (true) {
            BundleStreamSource.Event event = bundleStreamSource.nextEvent();
            switch (event) {
                case NEXT_OBJECT: {
                    if (byteBufferSerializerArray == null) {
                        byteBufferSerializerArray = this.writeHeader(bundleStreamSource, byteBuffer, writableByteChannel);
                    }
                    if (byteBufferSerializerArray[0] != null) {
                        if (!bundleStreamSource.assignDBID(dBIDVar)) {
                            throw new AbortException("An object did not have an DBID assigned.");
                        }
                        DBID dBID = DBIDUtil.deref(dBIDVar);
                        ByteBufferSerializer<?> byteBufferSerializer = byteBufferSerializerArray[0];
                        int n = byteBufferSerializer.getByteSize(dBID);
                        byteBuffer = this.ensureBuffer(n, byteBuffer, writableByteChannel);
                        byteBufferSerializer.toByteBuffer(byteBuffer, dBID);
                    }
                    int n = 1;
                    int n2 = 0;
                    while (true) {
                        if (n >= byteBufferSerializerArray.length) continue block5;
                        ByteBufferSerializer<?> byteBufferSerializer = byteBufferSerializerArray[n];
                        int n3 = byteBufferSerializer.getByteSize(bundleStreamSource.data(n2));
                        byteBuffer = this.ensureBuffer(n3, byteBuffer, writableByteChannel);
                        byteBufferSerializer.toByteBuffer(byteBuffer, bundleStreamSource.data(n2));
                        ++n;
                        ++n2;
                    }
                }
                case META_CHANGED: {
                    if (byteBufferSerializerArray == null) continue block5;
                    throw new AbortException("Meta changes are not supported, once the block header has been written.");
                }
                case END_OF_STREAM: {
                    break block5;
                }
                default: {
                    LOG.warning("Unknown bundle stream event. API inconsistent? " + (Object)((Object)event));
                }
            }
        }
        if (byteBuffer.position() > 0) {
            this.flushBuffer(byteBuffer, writableByteChannel);
        }
    }

    private void flushBuffer(ByteBuffer byteBuffer, WritableByteChannel writableByteChannel) throws IOException {
        byteBuffer.flip();
        writableByteChannel.write(byteBuffer);
        byteBuffer.flip();
        byteBuffer.limit(byteBuffer.capacity());
    }

    private ByteBuffer ensureBuffer(int n, ByteBuffer byteBuffer, WritableByteChannel writableByteChannel) throws IOException {
        if (byteBuffer.remaining() >= n) {
            return byteBuffer;
        }
        this.flushBuffer(byteBuffer, writableByteChannel);
        if (byteBuffer.remaining() >= n) {
            return byteBuffer;
        }
        return ByteBuffer.allocateDirect(Math.max(byteBuffer.capacity() << 1, byteBuffer.capacity() + n));
    }

    private ByteBufferSerializer<?>[] writeHeader(BundleStreamSource bundleStreamSource, ByteBuffer byteBuffer, WritableByteChannel writableByteChannel) throws IOException {
        BundleMeta bundleMeta = bundleStreamSource.getMeta();
        int n = bundleMeta.size();
        ByteBufferSerializer[] byteBufferSerializerArray = new ByteBufferSerializer[1 + n];
        assert (byteBuffer.position() == 0) : "Buffer is supposed to be at 0.";
        byteBuffer.putInt(-1475200238);
        if (bundleStreamSource.hasDBIDs()) {
            byteBuffer.putInt(1 + n);
            ByteBufferSerializer<DBID> byteBufferSerializer = TypeUtil.DBID.getSerializer();
            TypeInformationSerializer.STATIC.toByteBuffer(byteBuffer, TypeUtil.DBID);
            byteBufferSerializerArray[0] = byteBufferSerializer;
        } else {
            byteBuffer.putInt(n);
        }
        for (int i = 0; i < n; ++i) {
            SimpleTypeInformation simpleTypeInformation = (SimpleTypeInformation)bundleMeta.get(i);
            ByteBufferSerializer byteBufferSerializer = simpleTypeInformation.getSerializer();
            if (byteBufferSerializer == null) {
                throw new AbortException("Cannot serialize - no serializer found for type: " + simpleTypeInformation.toString());
            }
            TypeInformationSerializer.STATIC.toByteBuffer(byteBuffer, simpleTypeInformation);
            byteBufferSerializerArray[i + 1] = byteBufferSerializer;
        }
        return byteBufferSerializerArray;
    }
}

