/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialNorm;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"minimum", "min", "de.lmu.ifi.dbs.elki.distance.distancefunction.MinimumDistanceFunction"})
public class MinimumDistanceFunction
extends AbstractSpatialNorm {
    public static final MinimumDistanceFunction STATIC = new MinimumDistanceFunction();

    @Deprecated
    public MinimumDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = MinimumDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3;
            double d4 = numberVector.doubleValue(i);
            double d5 = d3 = d4 >= (d2 = numberVector2.doubleValue(i)) ? d4 - d2 : d2 - d4;
            if (!(d3 < d)) continue;
            d = d3;
        }
        return d;
    }

    @Override
    public double norm(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = numberVector.doubleValue(i);
            double d4 = d2 = d3 >= 0.0 ? d3 : -d3;
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable instanceof NumberVector && spatialComparable2 instanceof NumberVector) {
            return this.distance((NumberVector)spatialComparable, (NumberVector)spatialComparable2);
        }
        int n = MinimumDistanceFunction.dimensionality(spatialComparable, spatialComparable2);
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = spatialComparable2.getMin(i) - spatialComparable.getMax(i);
            if (d3 > 0.0) {
                d2 = d3;
            } else {
                double d4 = spatialComparable.getMin(i) - spatialComparable2.getMax(i);
                if (d4 > 0.0) {
                    d2 = d4;
                } else {
                    return 0.0;
                }
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    public String toString() {
        return "MinimumDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MinimumDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

