/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

public class PairCounting {
    public static final long MAX_SIZE = (long)Math.floor(Math.sqrt(9.223372036854776E18));
    protected long[] pairconfuse = null;

    protected PairCounting(ClusterContingencyTable clusterContingencyTable) {
        int n;
        int n2;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (n2 = 0; n2 < clusterContingencyTable.size1; ++n2) {
            n = clusterContingencyTable.contingency[n2][clusterContingencyTable.size2 + 1];
            if (clusterContingencyTable.breakNoiseClusters && BitsUtil.get(clusterContingencyTable.noise1, n2)) {
                if (!clusterContingencyTable.selfPairing) continue;
                l2 += (long)n;
                continue;
            }
            if (clusterContingencyTable.selfPairing) {
                l2 += (long)(n * n);
                continue;
            }
            l2 += (long)(n * (n - 1));
        }
        for (n2 = 0; n2 < clusterContingencyTable.size2; ++n2) {
            n = clusterContingencyTable.contingency[clusterContingencyTable.size1 + 1][n2];
            if (clusterContingencyTable.breakNoiseClusters && BitsUtil.get(clusterContingencyTable.noise2, n2)) {
                if (!clusterContingencyTable.selfPairing) continue;
                l3 += (long)n;
                continue;
            }
            if (clusterContingencyTable.selfPairing) {
                l3 += (long)(n * n);
                continue;
            }
            l3 += (long)(n * (n - 1));
        }
        for (n2 = 0; n2 < clusterContingencyTable.size1; ++n2) {
            for (n = 0; n < clusterContingencyTable.size2; ++n) {
                int n3 = clusterContingencyTable.contingency[n2][n];
                if (clusterContingencyTable.breakNoiseClusters && (BitsUtil.get(clusterContingencyTable.noise1, n2) || BitsUtil.get(clusterContingencyTable.noise2, n))) {
                    if (!clusterContingencyTable.selfPairing) continue;
                    l += (long)n3;
                    continue;
                }
                if (clusterContingencyTable.selfPairing) {
                    l += (long)(n3 * n3);
                    continue;
                }
                l += (long)(n3 * (n3 - 1));
            }
        }
        n2 = clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2];
        if (clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2 + 1] != n2 || clusterContingencyTable.contingency[clusterContingencyTable.size1 + 1][clusterContingencyTable.size2] != n2) {
            LoggingUtil.warning("PairCounting F-Measure is not well defined for overlapping and incomplete clusterings. The number of elements are: " + clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2 + 1] + " != " + clusterContingencyTable.contingency[clusterContingencyTable.size1 + 1][clusterContingencyTable.size2] + " elements.");
        }
        if (n2 < 0 || (long)n2 >= MAX_SIZE) {
            LoggingUtil.warning("Your data set size probably is too big for this implementation, which uses only long precision.");
        }
        l4 = clusterContingencyTable.selfPairing ? (long)(n2 * n2) : (long)(n2 * (n2 - 1));
        long l5 = l2 - l;
        long l6 = l3 - l;
        long l7 = l4 - (l + l5 + l6);
        this.pairconfuse = new long[]{l, l5, l6, l7};
    }

    public double fMeasure(double d) {
        double d2 = d * d;
        double d3 = (1.0 + d2) * (double)this.pairconfuse[0] / ((1.0 + d2) * (double)this.pairconfuse[0] + d2 * (double)this.pairconfuse[1] + (double)this.pairconfuse[2]);
        return d3;
    }

    public double f1Measure() {
        return this.fMeasure(1.0);
    }

    public double precision() {
        return (double)this.pairconfuse[0] / (double)(this.pairconfuse[0] + this.pairconfuse[2]);
    }

    public double recall() {
        return (double)this.pairconfuse[0] / (double)(this.pairconfuse[0] + this.pairconfuse[1]);
    }

    @Reference(authors="Fowlkes, E.B. and Mallows, C.L.", title="A method for comparing two hierarchical clusterings", booktitle="Journal of the American Statistical Association, Vol. 78 Issue 383")
    public double fowlkesMallows() {
        return Math.sqrt(this.precision() * this.recall());
    }

    @Reference(authors="Rand, W. M.", title="Objective Criteria for the Evaluation of Clustering Methods", booktitle="Journal of the American Statistical Association, Vol. 66 Issue 336", url="http://www.jstor.org/stable/10.2307/2284239")
    public double randIndex() {
        double d = this.pairconfuse[0] + this.pairconfuse[1] + this.pairconfuse[2] + this.pairconfuse[3];
        return (double)(this.pairconfuse[0] + this.pairconfuse[3]) / d;
    }

    public double adjustedRandIndex() {
        double d = this.pairconfuse[0] * this.pairconfuse[3] - this.pairconfuse[1] * this.pairconfuse[2];
        long l = (this.pairconfuse[0] + this.pairconfuse[1]) * (this.pairconfuse[1] + this.pairconfuse[3]);
        long l2 = (this.pairconfuse[0] + this.pairconfuse[2]) * (this.pairconfuse[2] + this.pairconfuse[3]);
        if (l + l2 > 0L) {
            return 2.0 * d / (double)(l + l2);
        }
        return 1.0;
    }

    public double jaccard() {
        double d = this.pairconfuse[0] + this.pairconfuse[1] + this.pairconfuse[2];
        return (double)this.pairconfuse[0] / d;
    }

    public long mirkin() {
        return 2L * (this.pairconfuse[1] + this.pairconfuse[2]);
    }
}

