/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSimplifiedSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.List;

@Reference(authors="R. B. Calinski and J. Harabasz", title="A dendrite method for cluster analysis", booktitle="Communications in Statistics-theory and Methods, 3(1)", url="http://dx.doi.org/10.1080/03610927408827101")
public class EvaluateVarianceRatioCriteria<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateVarianceRatioCriteria.class);
    private NoiseHandling noiseOption;
    private boolean penalize = true;
    private String key = EvaluateVarianceRatioCriteria.class.getName();

    public EvaluateVarianceRatioCriteria(NoiseHandling noiseHandling, boolean bl) {
        this.noiseOption = noiseHandling;
        this.penalize = bl;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database var1_1, Relation<? extends NumberVector> var2_2, Clustering<?> var3_3) {
        var4_4 = var3_3.getAllClusters();
        var5_5 = new NumberVector[var4_4.size()];
        var6_6 = EvaluateSimplifiedSilhouette.centroids(var2_2, var4_4, var5_5, this.noiseOption);
        var7_7 = RelationUtil.dimensionality(var2_2);
        var8_8 = new Centroid(var7_7);
        var9_9 = EvaluateVarianceRatioCriteria.globalCentroid(var8_8, var2_2, var4_4, var5_5, this.noiseOption);
        var10_10 = 0.0;
        var12_11 = 0.0;
        var14_12 = var4_4.iterator();
        var15_13 = 0;
        while (var14_12.hasNext()) {
            var16_15 = var14_12.next();
            if (var16_15.size() > 1 && !var16_15.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    var17_16 = var16_15.getIDs().iter();
                    while (var17_16.valid()) {
                        var12_11 += SquaredEuclideanDistanceFunction.STATIC.distance(var8_8, var2_2.get((DBIDRef)var17_16));
                        var17_16.advance();
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var17_16 = var16_15.getIDs().iter();
                    while (var17_16.valid()) {
                        var18_17 = var2_2.get((DBIDRef)var17_16);
                        var10_10 += SquaredEuclideanDistanceFunction.STATIC.distance(var5_5[var15_13], (NumberVector)var18_17);
                        var12_11 += SquaredEuclideanDistanceFunction.STATIC.distance(var8_8, (NumberVector)var18_17);
                        var17_16.advance();
                    }
                    break block0;
                }
            }
            ++var15_13;
        }
        var15_14 = (var12_11 - var10_10) / var10_10 * ((double)(var2_2.size() - var9_9) / ((double)var9_9 - 1.0));
        if (this.penalize && var6_6 > 0) {
            var15_14 *= (double)(var2_2.size() - var6_6) / (double)var2_2.size();
        }
        if (EvaluateVarianceRatioCriteria.LOG.isStatistics()) {
            EvaluateVarianceRatioCriteria.LOG.statistics(new StringStatistic(this.key + ".vrc.noise-handling", this.noiseOption.toString()));
            if (var6_6 > 0) {
                EvaluateVarianceRatioCriteria.LOG.statistics(new LongStatistic(this.key + ".vrc.ignored", var6_6));
            }
            EvaluateVarianceRatioCriteria.LOG.statistics(new DoubleStatistic(this.key + ".vrc", var15_14));
        }
        var17_16 = EvaluationResult.findOrCreate(var1_1.getHierarchy(), var3_3, "Internal Clustering Evaluation", "internal evaluation");
        var18_17 = var17_16.findOrCreateGroup("Distance-based Evaluation");
        var18_17.addMeasure("Variance Ratio Criteria", var15_14, 0.0, 1.0, 0.0, false);
        return var15_14;
    }

    /*
     * Unable to fully structure code
     */
    public static int globalCentroid(Centroid var0, Relation<? extends NumberVector> var1_1, List<? extends Cluster<?>> var2_2, NumberVector[] var3_3, NoiseHandling var4_4) {
        var5_5 = 0;
        var6_6 = var2_2.iterator();
        var7_7 = 0;
        while (var6_6.hasNext()) {
            var8_8 = var6_6.next();
            if (var8_8.size() > 1 && !var8_8.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[var4_4.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    var5_5 += var8_8.size();
                    var9_9 = var8_8.getIDs().iter();
                    while (var9_9.valid()) {
                        var0.put(var1_1.get(var9_9));
                        var9_9.advance();
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!EvaluateVarianceRatioCriteria.$assertionsDisabled && var3_3[var7_7] == null) {
                        throw new AssertionError();
                    }
                    var0.put(var3_3[var7_7], (double)var8_8.size());
                    ++var5_5;
                }
            }
            ++var7_7;
        }
        return var5_5;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(EuclideanDistanceFunction.STATIC.getInputTypeRestriction(), new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, clustering);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling;

        static {
            $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling = new int[NoiseHandling.values().length];
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.IGNORE_NOISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.TREAT_NOISE_AS_SINGLETONS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.MERGE_NOISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID NOISE_ID = new OptionID("vrc.noisehandling", "Control how noise should be treated.");
        public static final OptionID NO_PENALIZE_ID = new OptionID("silhouette.no-penalize-noise", "Do not penalize ignored noise.");
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            EnumParameter<NoiseHandling> enumParameter = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS);
            if (parameterization.grab(enumParameter)) {
                this.noiseOption = (NoiseHandling)((Object)enumParameter.getValue());
            }
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE && parameterization.grab(flag = new Flag(NO_PENALIZE_ID))) {
                this.penalize = flag.isFalse();
            }
        }

        @Override
        protected EvaluateVarianceRatioCriteria<? extends NumberVector> makeInstance() {
            return new EvaluateVarianceRatioCriteria(this.noiseOption, this.penalize);
        }
    }
}

