/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class JudgeOutlierScores
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(JudgeOutlierScores.class);
    public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("comphist.positive", "Class label for the 'positive' class.");
    public static final OptionID SCALING_ID = new OptionID("comphist.scaling", "Class to use as scaling function.");
    private Pattern positiveClassName;
    private ScalingFunction scaling;

    public JudgeOutlierScores(Pattern pattern, ScalingFunction scalingFunction) {
        this.positiveClassName = pattern;
        this.scaling = scalingFunction;
    }

    protected ScoreResult computeScore(DBIDs dBIDs, DBIDs dBIDs2, OutlierResult outlierResult) throws IllegalStateException {
        double d;
        ScalingFunction scalingFunction;
        if (this.scaling instanceof OutlierScalingFunction) {
            scalingFunction = (OutlierScalingFunction)this.scaling;
            scalingFunction.prepare(outlierResult);
        }
        double d2 = this.scaling.getMin();
        double d3 = this.scaling.getMax();
        if (Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3)) {
            scalingFunction = new IdentityScaling();
            LOG.warning("JudgeOutlierScores expects values between 0.0 and 1.0, but we don't have such a guarantee by the scaling function: min:" + d2 + " max:" + d3);
        } else {
            scalingFunction = d2 == 0.0 && d3 == 1.0 ? new IdentityScaling() : new LinearScaling(1.0 / (d3 - d2), -d2);
        }
        double d4 = 0.0;
        double d5 = 0.0;
        Object object = dBIDs.iter();
        while (object.valid()) {
            d = outlierResult.getScores().doubleValue((DBIDRef)object);
            d = scalingFunction.getScaled(this.scaling.getScaled(d));
            d4 += 1.0 - d;
            object.advance();
        }
        object = dBIDs2.iter();
        while (object.valid()) {
            d = outlierResult.getScores().doubleValue((DBIDRef)object);
            d = scalingFunction.getScaled(this.scaling.getScaled(d));
            d5 += d;
            object.advance();
        }
        LOG.verbose("Scores: " + (d4 /= (double)dBIDs.size()) + " " + (d5 /= (double)dBIDs2.size()));
        object = new ArrayList(1);
        ((ArrayList)object).add(new Vector((d4 + d5) * 0.5, d4, d5));
        return new ScoreResult((Collection<Vector>)object);
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Database database = ResultUtil.findDatabase(resultHierarchy);
        ArrayList<OutlierResult> arrayList = ResultUtil.filterResults(resultHierarchy, OutlierResult.class);
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(((OutlierResult)arrayList.iterator().next()).getScores().getDBIDs());
        ArrayModifiableDBIDs arrayModifiableDBIDs = DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName);
        hashSetModifiableDBIDs.removeDBIDs(arrayModifiableDBIDs);
        for (OutlierResult outlierResult : arrayList) {
            database.getHierarchy().add(outlierResult, this.computeScore(hashSetModifiableDBIDs, arrayModifiableDBIDs, outlierResult));
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private Pattern positiveClassName;
        private ScalingFunction scaling;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (parameterization.grab(patternParameter)) {
                this.positiveClassName = (Pattern)patternParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class))) {
                this.scaling = (ScalingFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected JudgeOutlierScores makeInstance() {
            return new JudgeOutlierScores(this.positiveClassName, this.scaling);
        }
    }

    public class ScoreResult
    extends CollectionResult<Vector> {
        public ScoreResult(Collection<Vector> collection) {
            super("Outlier Score", "outlier-score", collection);
        }
    }
}

