/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.PolynomialApproximation;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import java.util.Arrays;
import java.util.logging.Logger;

class MkAppTreeNode<O>
extends AbstractMTreeNode<O, MkAppTreeNode<O>, MkAppEntry> {
    private static final long serialVersionUID = 2L;

    public MkAppTreeNode() {
    }

    public MkAppTreeNode(int n, boolean bl) {
        super(n, bl, MkAppEntry.class);
    }

    protected PolynomialApproximation knnDistanceApproximation() {
        int n;
        int n2 = 0;
        double[] dArray = null;
        for (n = 0; n < this.getNumEntries(); ++n) {
            MkAppEntry mkAppEntry = (MkAppEntry)this.getEntry(n);
            PolynomialApproximation polynomialApproximation = mkAppEntry.getKnnDistanceApproximation();
            if (dArray == null) {
                n2 = polynomialApproximation.getPolynomialOrder();
                dArray = new double[n2];
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + polynomialApproximation.getB(i);
            }
        }
        n = 0;
        while (n < n2) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / (double)n2;
        }
        if (LoggingConfiguration.DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("b " + FormatUtil.format(dArray, FormatUtil.NF4));
            Logger.getLogger(this.getClass().getName()).fine(stringBuilder.toString());
        }
        return new PolynomialApproximation(dArray);
    }

    @Override
    public boolean adjustEntry(MkAppEntry mkAppEntry, DBID dBID, double d, AbstractMTree<O, MkAppTreeNode<O>, MkAppEntry, ?> abstractMTree) {
        super.adjustEntry(mkAppEntry, dBID, d, abstractMTree);
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkAppEntry mkAppEntry, MkAppTreeNode<O> mkAppTreeNode, int n, AbstractMTree<O, MkAppTreeNode<O>, MkAppEntry, ?> abstractMTree) {
        super.integrityCheckParameters(mkAppEntry, mkAppTreeNode, n, abstractMTree);
        MkAppEntry mkAppEntry2 = (MkAppEntry)mkAppTreeNode.getEntry(n);
        PolynomialApproximation polynomialApproximation = this.knnDistanceApproximation();
        PolynomialApproximation polynomialApproximation2 = mkAppEntry2.getKnnDistanceApproximation();
        if (!Arrays.equals(polynomialApproximation2.getCoefficients(), polynomialApproximation.getCoefficients())) {
            String string = polynomialApproximation.toString();
            String string2 = mkAppEntry2.getKnnDistanceApproximation().toString();
            throw new RuntimeException("Wrong polynomial approximation in node " + mkAppTreeNode.getPageID() + " at index " + n + " (child " + mkAppEntry2 + ")" + "\nsoll: " + string + ",\n ist: " + string2);
        }
    }
}

