/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.vafile.DAFile;
import de.lmu.ifi.dbs.elki.index.vafile.VALPNormDistance;
import de.lmu.ifi.dbs.elki.index.vafile.VectorApproximation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Matthias Schubert, Ziyue Zhu", title="Efficient Query Processing in Arbitrary Subspaces Using Vector Approximations", booktitle="Proc. 18th Int. Conf. on Scientific and Statistical Database Management (SSDBM 06), Wien, Austria, 2006", url="http://dx.doi.org/10.1109/SSDBM.2006.23")
public class PartialVAFile<V extends NumberVector>
extends AbstractRefiningIndex<V>
implements KNNIndex<V>,
RangeIndex<V> {
    private static final Logging LOG = Logging.getLogger(PartialVAFile.class);
    List<DAFile> daFiles;
    private final int partitions;
    private final int pageSize;
    private double[][] splitPartitions;
    protected Statistics stats;
    private ArrayList<VectorApproximation> vectorApprox;

    public PartialVAFile(int n, Relation<V> relation, int n2) {
        super(relation);
        this.pageSize = n;
        this.partitions = n2;
        this.stats = new Statistics(this.getClass().getName());
    }

    @Override
    public void initialize() throws IllegalStateException {
        Object object;
        if (this.splitPartitions != null) {
            throw new IllegalStateException("Data already inserted.");
        }
        if (MathUtil.log2(this.partitions) != (double)((int)MathUtil.log2(this.partitions))) {
            throw new IllegalArgumentException("Number of partitions must be a power of 2!");
        }
        int n = RelationUtil.dimensionality(this.relation);
        this.splitPartitions = new double[n][];
        this.daFiles = new ArrayList<DAFile>(n);
        for (int i = 0; i < n; ++i) {
            object = new DAFile(this.relation, i, this.partitions);
            this.splitPartitions[i] = ((DAFile)object).getSplitPositions();
            this.daFiles.add((DAFile)object);
        }
        this.vectorApprox = new ArrayList();
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            object = DBIDUtil.deref(dBIDIter);
            NumberVector numberVector = (NumberVector)this.relation.get((DBIDRef)object);
            VectorApproximation vectorApproximation = this.calculateFullApproximation((DBID)object, numberVector);
            this.vectorApprox.add(vectorApproximation);
            dBIDIter.advance();
        }
    }

    @Override
    public String getShortName() {
        return "pva-file";
    }

    @Override
    public String getLongName() {
        return "partial va-file";
    }

    @Override
    public Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
        this.stats.logStatistics();
    }

    protected VectorApproximation calculateFullApproximation(DBID dBID, V v) {
        int[] nArray = new int[v.getDimensionality()];
        for (int i = 0; i < this.splitPartitions.length; ++i) {
            double[] dArray = this.daFiles.get(i).getSplitPositions();
            double d = v.doubleValue(i);
            int n = dArray.length - 1;
            if (d < dArray[0]) {
                nArray[i] = 0;
                if (dBID == null) continue;
                LOG.warning("Vector outside of VAFile grid!");
                continue;
            }
            if (d > dArray[n]) {
                nArray[i] = n - 1;
                if (dBID == null) continue;
                LOG.warning("Vector outside of VAFile grid!");
                continue;
            }
            int n2 = Arrays.binarySearch(dArray, d);
            nArray[i] = n2 = n2 >= 0 ? n2 : -n2 - 2;
        }
        return new VectorApproximation(dBID, nArray);
    }

    @Override
    public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
        DistanceFunction<V> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof SubspaceLPNormDistanceFunction) {
            double d = ((SubspaceLPNormDistanceFunction)distanceFunction).getP();
            long[] lArray = ((SubspaceLPNormDistanceFunction)distanceFunction).getSelectedDimensions();
            return new PartialVAFileKNNQuery(distanceQuery, d, lArray);
        }
        if (distanceFunction instanceof LPNormDistanceFunction) {
            double d = ((LPNormDistanceFunction)distanceFunction).getP();
            long[] lArray = BitsUtil.ones(RelationUtil.dimensionality(distanceQuery.getRelation()));
            return new PartialVAFileKNNQuery(distanceQuery, d, lArray);
        }
        return null;
    }

    @Override
    public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
        DistanceFunction<V> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof SubspaceLPNormDistanceFunction) {
            double d = ((SubspaceLPNormDistanceFunction)distanceFunction).getP();
            long[] lArray = ((SubspaceLPNormDistanceFunction)distanceFunction).getSelectedDimensions();
            return new PartialVAFileRangeQuery(distanceQuery, d, lArray);
        }
        if (distanceFunction instanceof LPNormDistanceFunction) {
            double d = ((LPNormDistanceFunction)distanceFunction).getP();
            long[] lArray = BitsUtil.ones(RelationUtil.dimensionality(distanceQuery.getRelation()));
            return new PartialVAFileRangeQuery(distanceQuery, d, lArray);
        }
        return null;
    }

    protected static void calculateSelectivityCoeffs(List<DoubleObjPair<DAFile>> list, NumberVector numberVector, double d) {
        int n = numberVector.getDimensionality();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        VectorApproximation vectorApproximation = PartialVAFile.calculatePartialApproximation(null, numberVector, list);
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            dArray[i] = d2 - d;
            dArray2[i] = d2 + d;
        }
        Vector vector = new Vector(dArray);
        VectorApproximation vectorApproximation2 = PartialVAFile.calculatePartialApproximation(null, vector, list);
        Vector vector2 = new Vector(dArray2);
        VectorApproximation vectorApproximation3 = PartialVAFile.calculatePartialApproximation(null, vector2, list);
        for (int i = 0; i < list.size(); ++i) {
            int n2 = vectorApproximation.getApproximation(i) - vectorApproximation2.getApproximation(i) + (vectorApproximation3.getApproximation(i) - vectorApproximation.getApproximation(i)) + 1;
            list.get((int)i).first = n2;
        }
    }

    protected static VectorApproximation calculatePartialApproximation(DBID dBID, NumberVector numberVector, List<DoubleObjPair<DAFile>> list) {
        int[] nArray = new int[numberVector.getDimensionality()];
        for (int i = 0; i < list.size(); ++i) {
            double d = numberVector.doubleValue(i);
            double[] dArray = ((DAFile)list.get((int)i).second).getSplitPositions();
            assert (dArray != null) : "borders are null";
            int n = dArray.length - 1;
            if (d < dArray[0]) {
                nArray[i] = 0;
                continue;
            }
            if (d > dArray[n]) {
                nArray[i] = n - 1;
                continue;
            }
            for (int j = 0; j < n; ++j) {
                if (!(d >= dArray[j]) || !(d < dArray[j + 1]) || nArray[i] == -1) continue;
                nArray[i] = j;
            }
        }
        return new VectorApproximation(dBID, nArray);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V, PartialVAFile<V>> {
        public static final OptionID PARTITIONS_ID = new OptionID("vafile.partitions", "Number of partitions to use in each dimension.");
        int pagesize = 1;
        int numpart = 2;

        public Factory(int n, int n2) {
            this.pagesize = n;
            this.numpart = n2;
        }

        @Override
        public PartialVAFile<V> instantiate(Relation<V> relation) {
            return new PartialVAFile<V>(this.pagesize, relation, this.numpart);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            int pagesize = 1;
            int numpart = 2;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                IntParameter intParameter = new IntParameter(AbstractPageFileFactory.Parameterizer.PAGE_SIZE_ID, 1024);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.pagesize = (Integer)intParameter.getValue();
                }
                IntParameter intParameter2 = new IntParameter(PARTITIONS_ID);
                intParameter2.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
                if (parameterization.grab(intParameter2)) {
                    this.numpart = (Integer)intParameter2.getValue();
                }
            }

            @Override
            protected Factory<?> makeInstance() {
                return new Factory(this.pagesize, this.numpart);
            }
        }
    }

    protected static class WorstCaseDistComparator
    implements Comparator<DAFile> {
        private VALPNormDistance dist;

        public WorstCaseDistComparator(VALPNormDistance vALPNormDistance) {
            this.dist = vALPNormDistance;
        }

        @Override
        public int compare(DAFile dAFile, DAFile dAFile2) {
            return Double.compare(this.dist.getPartialMaxMaxDist(dAFile.getDimension()), this.dist.getPartialMaxMaxDist(dAFile2.getDimension()));
        }
    }

    public class PartialVAFileKNNQuery
    extends AbstractRefiningIndex.AbstractKNNQuery {
        private double p;
        private long[] subspace;

        public PartialVAFileKNNQuery(DistanceQuery<V> distanceQuery, double d, long[] lArray) {
            super(distanceQuery);
            this.p = d;
            this.subspace = lArray;
        }

        @Override
        public KNNList getKNNForObject(V v, int n) {
            Object object;
            PartialVAFile.this.stats.incrementIssuedQueries();
            long l = System.nanoTime();
            VectorApproximation vectorApproximation = PartialVAFile.this.calculateFullApproximation(null, v);
            VALPNormDistance vALPNormDistance = new VALPNormDistance(this.p, PartialVAFile.this.splitPartitions, (NumberVector)v, vectorApproximation);
            List<DAFile> list = this.getWorstCaseDistOrder(vALPNormDistance, this.subspace);
            int n2 = BitsUtil.cardinality(this.subspace);
            int n3 = 2 * n2 / 3;
            n3 = Math.max(1, n3);
            if (LOG.isDebuggingFine()) {
                LOG.fine("subspaceDims=" + n2 + ", reducedDims=" + n3);
            }
            LinkedList<PartialVACandidate> linkedList = this.filter1(n, n3, list, vectorApproximation, n2, vALPNormDistance);
            if (LOG.isDebuggingFine()) {
                LOG.fine("candidate set after filter 1: " + linkedList.size());
            }
            LinkedList<PartialVACandidate> linkedList2 = null;
            int n4 = n3;
            int n5 = 2;
            if (n2 <= n3) {
                linkedList2 = linkedList;
            } else {
                while (linkedList2 == null || this.getIOCosts(linkedList2.size(), n2) >= this.getIOCosts(list.get(0), n2 - n4) && n4 < n2) {
                    if (linkedList2 != null && LOG.isDebuggingFine()) {
                        LOG.fine("filter " + n5 + ": refining costs " + this.getIOCosts(linkedList2.size(), n2) + " (" + linkedList2.size() + "/" + n2 + "), DA file costs " + this.getIOCosts(list.get(0), n2 - n4) + " (dim " + (n4 + 1) + " of " + n2 + ")");
                    }
                    if (linkedList2 != null) {
                        linkedList = linkedList2;
                    }
                    linkedList2 = new LinkedList();
                    object = new DoubleMaxHeap(n + 1);
                    for (PartialVACandidate partialVACandidate : linkedList) {
                        int n6 = list.get(n4).getDimension();
                        int n7 = partialVACandidate.getApproximation(n6);
                        partialVACandidate.minDistP += vALPNormDistance.getPartialMinDist(n6, n7);
                        partialVACandidate.maxDistP += vALPNormDistance.getPartialMaxDist(n6, n7) - vALPNormDistance.getPartialMaxMaxDist(n6);
                        if (((DoubleMaxHeap)object).size() >= n && !(partialVACandidate.minDistP <= ((DoubleMaxHeap)object).peek())) continue;
                        linkedList2.add(partialVACandidate);
                        ((DoubleMaxHeap)object).add(partialVACandidate.maxDistP, n);
                    }
                    if (LOG.isDebuggingFine()) {
                        LOG.fine("candidate set after filter " + n5 + ": " + linkedList2.size());
                    }
                    ++n4;
                    ++n5;
                }
            }
            PartialVAFile.this.stats.incrementScannedBytes(this.relation.size() * VectorApproximation.byteOnDisk(n4, PartialVAFile.this.partitions));
            object = new ArrayList<PartialVACandidate>(linkedList2);
            Collections.sort(object);
            KNNList kNNList = this.retrieveAccurateDistances((List<PartialVACandidate>)object, n, this.subspace, v);
            PartialVAFile.this.stats.incrementQueryTime(System.nanoTime() - l);
            return kNNList;
        }

        private LinkedList<PartialVACandidate> filter1(int n, int n2, List<DAFile> list, VectorApproximation vectorApproximation, int n3, VALPNormDistance vALPNormDistance) {
            Object object;
            LinkedList<PartialVACandidate> linkedList = new LinkedList<PartialVACandidate>();
            DoubleMaxHeap doubleMaxHeap = new DoubleMaxHeap(n + 1);
            for (VectorApproximation vectorApproximation2 : PartialVAFile.this.vectorApprox) {
                int n4;
                object = new PartialVACandidate(vectorApproximation2);
                for (n4 = 0; n4 < n2; ++n4) {
                    int n5 = list.get(n4).getDimension();
                    int n6 = ((PartialVACandidate)object).getApproximation(n5);
                    ((PartialVACandidate)object).minDistP += vALPNormDistance.getPartialMinDist(n5, n6);
                    ((PartialVACandidate)object).maxDistP += vALPNormDistance.getPartialMaxDist(n5, n6);
                }
                for (n4 = n2; n4 < n3; ++n4) {
                    ((PartialVACandidate)object).maxDistP += vALPNormDistance.getPartialMaxMaxDist(list.get(n4).getDimension());
                }
                if (doubleMaxHeap.size() >= n && !(((PartialVACandidate)object).minDistP <= doubleMaxHeap.peek())) continue;
                linkedList.add((PartialVACandidate)object);
                doubleMaxHeap.add(((PartialVACandidate)object).maxDistP, n);
            }
            double d = doubleMaxHeap.peek();
            object = linkedList.iterator();
            while (object.hasNext()) {
                PartialVACandidate partialVACandidate = (PartialVACandidate)object.next();
                if (!(partialVACandidate.minDistP > d)) continue;
                object.remove();
            }
            return linkedList;
        }

        private int getIOCosts(int n, int n2) {
            return n * (n2 * 8 + 4);
        }

        private int getIOCosts(DAFile dAFile, int n) {
            return dAFile.getIOCosts() * n;
        }

        public List<DAFile> getWorstCaseDistOrder(VALPNormDistance vALPNormDistance, long[] lArray) {
            int n = BitsUtil.cardinality(lArray);
            ArrayList<DAFile> arrayList = new ArrayList<DAFile>(n);
            int n2 = BitsUtil.nextSetBit(lArray, 0);
            while (n2 >= 0) {
                arrayList.add(PartialVAFile.this.daFiles.get(n2));
                n2 = BitsUtil.nextSetBit(lArray, n2 + 1);
            }
            Collections.sort(arrayList, new WorstCaseDistComparator(vALPNormDistance));
            return arrayList;
        }

        protected KNNList retrieveAccurateDistances(List<PartialVACandidate> list, int n, long[] lArray, V v) {
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            for (PartialVACandidate partialVACandidate : list) {
                double d = kNNHeap.getKNNDistance();
                DBID dBID = partialVACandidate.getId();
                if (kNNHeap.size() >= n && !(partialVACandidate.minDistP < d)) continue;
                double d2 = this.refine(dBID, v);
                PartialVAFile.this.stats.incrementRefinements();
                if (!(d2 < d)) continue;
                kNNHeap.insert(d2, dBID);
            }
            return kNNHeap.toKNNList();
        }
    }

    public class PartialVAFileRangeQuery
    extends AbstractRefiningIndex.AbstractRangeQuery {
        private double p;
        private long[] subspace;

        public PartialVAFileRangeQuery(DistanceQuery<V> distanceQuery, double d, long[] lArray) {
            super(distanceQuery);
            this.p = d;
            this.subspace = lArray;
        }

        @Override
        public void getRangeForObject(V v, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            PartialVAFile.this.stats.incrementIssuedQueries();
            long l = System.nanoTime();
            double d2 = Math.pow(d, this.p);
            VectorApproximation vectorApproximation = PartialVAFile.this.calculateFullApproximation(null, v);
            VALPNormDistance vALPNormDistance = new VALPNormDistance(this.p, PartialVAFile.this.splitPartitions, (NumberVector)v, vectorApproximation);
            ArrayList<DoubleObjPair<DAFile>> arrayList = new ArrayList<DoubleObjPair<DAFile>>(BitsUtil.cardinality(this.subspace));
            int n = BitsUtil.nextSetBit(this.subspace, 0);
            while (n >= 0) {
                DAFile dAFile = PartialVAFile.this.daFiles.get(n);
                arrayList.add(new DoubleObjPair<DAFile>(-1.0, dAFile));
                n = BitsUtil.nextSetBit(this.subspace, n + 1);
            }
            PartialVAFile.calculateSelectivityCoeffs(arrayList, v, d);
            Collections.sort(arrayList, Collections.reverseOrder());
            n = 0;
            for (VectorApproximation vectorApproximation2 : PartialVAFile.this.vectorApprox) {
                DBID dBID = vectorApproximation2.getId();
                PartialVACandidate partialVACandidate = new PartialVACandidate(vectorApproximation2);
                boolean bl = false;
                for (DoubleObjPair doubleObjPair : arrayList) {
                    int n2 = ((DAFile)doubleObjPair.second).getDimension();
                    int n3 = vectorApproximation2.getApproximation(n2);
                    partialVACandidate.minDistP += vALPNormDistance.getPartialMinDist(n2, n3);
                    partialVACandidate.maxDistP += vALPNormDistance.getPartialMaxDist(n2, n3);
                    if (!(partialVACandidate.minDistP > d2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ++n;
                if (partialVACandidate.maxDistP <= d2) {
                    modifiableDoubleDBIDList.add(this.refine(dBID, v), dBID);
                    continue;
                }
                double d3 = this.refine(dBID, v);
                PartialVAFile.this.stats.incrementRefinements();
                if (!(d3 <= d)) continue;
                modifiableDoubleDBIDList.add(d3, dBID);
            }
            modifiableDoubleDBIDList.sort();
            PartialVAFile.this.stats.incrementScannedBytes(this.relation.size() * VectorApproximation.byteOnDisk(BitsUtil.cardinality(this.subspace), PartialVAFile.this.partitions));
            PartialVAFile.this.stats.incrementQueryTime(System.nanoTime() - l);
            if (LOG.isDebuggingFine()) {
                LOG.fine("query = " + v);
                LOG.fine("database: " + this.relation.size() + ", candidates: " + n + ", results: " + modifiableDoubleDBIDList.size());
            }
        }
    }

    protected static class PartialVACandidate
    implements Comparable<PartialVACandidate> {
        protected double maxDistP = 0.0;
        protected double minDistP = 0.0;
        private final VectorApproximation approx;

        public PartialVACandidate(VectorApproximation vectorApproximation) {
            this.approx = vectorApproximation;
        }

        public int getApproximation(int n) {
            return this.approx.getApproximation(n);
        }

        public DBID getId() {
            return this.approx.getId();
        }

        public String toString() {
            return this.approx.toString() + ", bounds^p: [" + this.minDistP + ", " + this.maxDistP + "]";
        }

        @Override
        public int compareTo(PartialVACandidate partialVACandidate) {
            return Double.compare(this.minDistP, partialVACandidate.minDistP);
        }
    }

    public static class Statistics {
        private Counter scannedBytes;
        private Counter queryTime;
        private Counter issuedQueries;
        private Counter refinements;

        protected Statistics(String string) {
            this.scannedBytes = LOG.isStatistics() ? LOG.newCounter(string + ".scannedBytes") : null;
            this.queryTime = LOG.isStatistics() ? LOG.newCounter(string + ".queryTime") : null;
            this.issuedQueries = LOG.isStatistics() ? LOG.newCounter(string + ".issuedQueries") : null;
            this.refinements = LOG.isStatistics() ? LOG.newCounter(string + ".refinements") : null;
        }

        public void logStatistics() {
            if (this.scannedBytes != null) {
                LOG.statistics(this.scannedBytes);
            }
            if (this.queryTime != null) {
                LOG.statistics(this.queryTime);
            }
            if (this.issuedQueries != null) {
                LOG.statistics(this.issuedQueries);
            }
            if (this.refinements != null) {
                LOG.statistics(this.refinements);
            }
        }

        protected void incrementScannedBytes(long l) {
            if (this.scannedBytes != null) {
                this.scannedBytes.increment(l);
            }
        }

        protected void incrementQueryTime(long l) {
            if (this.queryTime != null) {
                this.queryTime.increment(l);
            }
        }

        protected void incrementIssuedQueries() {
            if (this.issuedQueries != null) {
                this.issuedQueries.increment();
            }
        }

        protected void incrementRefinements() {
            if (this.refinements != null) {
                this.refinements.increment();
            }
        }
    }
}

