/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import de.lmu.ifi.dbs.elki.utilities.pairs.IntIntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

@Reference(authors="David Sinclair", title="S-hull: a fast sweep-hull routine for Delaunay triangulation", booktitle="Online: http://s-hull.org/")
public class SweepHullDelaunay2D {
    private static final Logging LOG = Logging.getLogger(SweepHullDelaunay2D.class);
    private List<Vector> points;
    private ArrayList<Triangle> tris = null;
    private LinkedList<IntIntPair> hull = null;

    public SweepHullDelaunay2D() {
        this(new ArrayList<Vector>());
    }

    public SweepHullDelaunay2D(List<Vector> list) {
        this.points = list;
    }

    public void add(Vector vector) {
        this.points.add(vector);
        this.hull = null;
        this.tris = null;
    }

    void run(boolean bl) {
        int n;
        Object object;
        int n2;
        Object object2;
        if (this.points.size() < 3) {
            throw new UnsupportedOperationException("There is no delaunay triangulation for less than three objects!");
        }
        int n3 = this.points.size() - 1;
        this.hull = new LinkedList();
        this.tris = bl ? null : new ArrayList(n3);
        Object[] objectArray = new DoubleIntPair[n3];
        Iterator<Vector> iterator = this.points.iterator();
        Vector vector = iterator.next();
        int n4 = 0;
        while (iterator.hasNext()) {
            assert (n4 < n3);
            object2 = iterator.next();
            objectArray[n4] = new DoubleIntPair(SweepHullDelaunay2D.quadraticEuclidean(vector, (Vector)object2), n4 + 1);
            ++n4;
        }
        assert (objectArray[n3 - 1] != null);
        Arrays.sort(objectArray);
        assert (((DoubleIntPair)objectArray[0]).first > 0.0);
        int n5 = ((DoubleIntPair)objectArray[0]).second;
        n4 = 1;
        object2 = new Triangle(0, n5, -1);
        ((Triangle)object2).r2 = Double.MAX_VALUE;
        Object object3 = new Triangle(0, n5, -1);
        int n6 = -1;
        for (n2 = n4; n2 < n3; ++n2) {
            ((Triangle)object3).c = ((DoubleIntPair)objectArray[n2]).second;
            if (((Triangle)object3).updateCircumcircle(this.points) && ((Triangle)object3).r2 < ((Triangle)object2).r2) {
                ((Triangle)object2).copyFrom((Triangle)object3);
                n6 = n2;
                continue;
            }
            if (((Triangle)object2).r2 * 4.0 < ((DoubleIntPair)objectArray[n2]).first) break;
        }
        assert (n6 != -1);
        if (n6 > 1) {
            Object object4 = objectArray[n6];
            System.arraycopy(objectArray, 1, objectArray, 2, n6 - 1);
            objectArray[1] = object4;
        }
        n4 = 2;
        ((Triangle)object2).makeClockwise(this.points);
        if (!bl) {
            this.tris.add((Triangle)object2);
        }
        this.hull.add(new IntIntPair(((Triangle)object2).a, 0));
        this.hull.add(new IntIntPair(((Triangle)object2).b, 0));
        this.hull.add(new IntIntPair(((Triangle)object2).c, 0));
        if (LOG.isDebuggingFinest()) {
            this.debugHull();
        }
        object3 = ((Triangle)object2).m;
        for (n6 = n4; n6 < n3; ++n6) {
            ((DoubleIntPair)objectArray[n6]).first = SweepHullDelaunay2D.quadraticEuclidean((Vector)object3, this.points.get(((DoubleIntPair)objectArray[n6]).second));
        }
        Arrays.sort(objectArray, n4, n3);
        for (n6 = n4; n6 < n3; ++n6) {
            int n7;
            ListIterator<IntIntPair> listIterator;
            int n8;
            int n9;
            Triangle triangle;
            Object object5;
            Object object6;
            n2 = ((DoubleIntPair)objectArray[n6]).second;
            object = this.points.get(n2);
            LinkedList<Object> linkedList = bl ? null : new LinkedList<Object>();
            n = -1;
            int n10 = -1;
            Iterator<IntIntPair> iterator2 = this.hull.descendingIterator();
            IntIntPair intIntPair = this.hull.getFirst();
            Object object7 = this.points.get(intIntPair.first);
            int n11 = this.hull.size() - 1;
            while (iterator2.hasNext()) {
                object6 = iterator2.next();
                object5 = this.points.get(((IntIntPair)object6).first);
                if (n10 < 0) {
                    if (this.leftOf((Vector)object5, (Vector)object7, (Vector)object)) {
                        n = n11;
                        n10 = n11;
                        if (!bl) {
                            triangle = new Triangle(n2, intIntPair.first, ((IntIntPair)object6).first);
                            assert (triangle.isClockwise(this.points));
                            assert (((IntIntPair)object6).second >= 0);
                            triangle.updateCircumcircle(this.points);
                            triangle.bc = ((IntIntPair)object6).second;
                            linkedList.addFirst(triangle);
                        }
                    }
                } else {
                    if (!this.leftOf((Vector)object5, (Vector)object7, (Vector)object)) break;
                    n = n11;
                    if (!bl) {
                        triangle = new Triangle(n2, intIntPair.first, ((IntIntPair)object6).first);
                        assert (triangle.isClockwise(this.points));
                        assert (((IntIntPair)object6).second >= 0);
                        triangle.updateCircumcircle(this.points);
                        triangle.bc = ((IntIntPair)object6).second;
                        linkedList.addFirst(triangle);
                    }
                }
                intIntPair = object6;
                object7 = object5;
                --n11;
            }
            if (n10 == this.hull.size() - 1) {
                iterator2 = this.hull.iterator();
                intIntPair = iterator2.next();
                object7 = this.points.get(intIntPair.first);
                while (iterator2.hasNext()) {
                    IntIntPair intIntPair2 = iterator2.next();
                    object6 = this.points.get(intIntPair2.first);
                    if (!this.leftOf((Vector)object7, (Vector)object6, (Vector)object)) break;
                    ++n10;
                    if (!bl) {
                        object5 = new Triangle(n2, intIntPair2.first, intIntPair.first);
                        assert (((Triangle)object5).isClockwise(this.points));
                        assert (intIntPair.second >= 0);
                        ((Triangle)object5).updateCircumcircle(this.points);
                        ((Triangle)object5).bc = intIntPair.second;
                        linkedList.addLast(object5);
                    }
                    intIntPair = intIntPair2;
                    object7 = object6;
                }
            }
            assert (n >= 0 && n10 >= n);
            if (bl) {
                n9 = -1;
                n8 = -1;
            } else {
                int n12;
                n9 = n12 = this.tris.size();
                n8 = n12 + linkedList.size() - 1;
            }
            int n13 = this.hull.size();
            if (LOG.isDebuggingFinest()) {
                LOG.debugFinest("Size: " + n13 + " start: " + n + " end: " + n10);
            }
            if (n10 < n13) {
                listIterator = this.hull.listIterator();
                for (n7 = 0; n7 <= n; ++n7) {
                    listIterator.next();
                }
                while (n7 <= n10) {
                    listIterator.next();
                    listIterator.remove();
                    ++n7;
                }
                listIterator.add(new IntIntPair(n2, n8));
                listIterator.previous();
                if (!bl) {
                    if (listIterator.hasPrevious()) {
                        ((IntIntPair)listIterator.previous()).second = n9;
                    } else {
                        this.hull.getLast().second = n9;
                    }
                }
            } else {
                listIterator = this.hull.listIterator();
                for (n7 = n13; n7 <= n10; ++n7) {
                    listIterator.next();
                    listIterator.remove();
                }
                listIterator.add(new IntIntPair(n2, n8));
                n7 -= n13;
                object5 = null;
                while (n7 <= n) {
                    object5 = (IntIntPair)listIterator.next();
                    ++n7;
                }
                assert (object5 != null);
                ((IntIntPair)object5).second = n9;
                while (listIterator.hasNext()) {
                    listIterator.next();
                    listIterator.remove();
                }
            }
            if (LOG.isDebuggingFinest()) {
                this.debugHull();
            }
            if (bl) continue;
            int n14 = this.tris.size();
            Iterator iterator3 = linkedList.iterator();
            int n15 = 0;
            while (iterator3.hasNext()) {
                triangle = (Triangle)iterator3.next();
                triangle.ca = n15 > 0 ? n14 + n15 - 1 : -1;
                triangle.ab = iterator3.hasNext() ? n14 + n15 + 1 : -1;
                assert (triangle.bc >= 0);
                Triangle triangle2 = this.tris.get(triangle.bc);
                Orientation orientation = triangle.findOrientation(triangle2);
                assert (orientation != null) : "Inconsistent triangles: " + triangle + " " + triangle2;
                switch (orientation) {
                    case ORIENT_BC_BA: {
                        assert (triangle2.ab == -1) : "Inconsistent triangles: " + triangle + " " + triangle2;
                        triangle2.ab = n14 + n15;
                        break;
                    }
                    case ORIENT_BC_CB: {
                        assert (triangle2.bc == -1) : "Inconsistent triangles: " + triangle + " " + triangle2;
                        triangle2.bc = n14 + n15;
                        break;
                    }
                    case ORIENT_BC_AC: {
                        assert (triangle2.ca == -1) : "Inconsistent triangles: " + triangle + " " + triangle2;
                        triangle2.ca = n14 + n15;
                        break;
                    }
                    default: {
                        assert (triangle.isClockwise(this.points));
                        assert (triangle2.isClockwise(this.points));
                        throw new RuntimeException("Inconsistent triangles: " + triangle + " " + triangle2 + " size:" + this.tris.size());
                    }
                }
                this.tris.add(triangle);
                ++n15;
            }
            assert (this.tris.size() == n8 + 1);
        }
        if (!bl) {
            n6 = this.tris.size();
            long[] lArray = BitsUtil.zero(n6);
            object = BitsUtil.zero(n6);
            int n16 = this.flipTriangles(null, lArray);
            for (n = 1; n < 2000 && n16 > 0; ++n) {
                n16 = n % 2 == 1 ? this.flipTriangles(lArray, (long[])object) : this.flipTriangles((long[])object, lArray);
            }
        }
    }

    void debugHull() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IntIntPair intIntPair : this.hull) {
            stringBuilder.append(intIntPair).append(' ');
        }
        LOG.debugFinest(stringBuilder);
    }

    int flipTriangles(long[] lArray, long[] lArray2) {
        int n = this.tris.size();
        int n2 = 0;
        BitsUtil.zeroI(lArray2);
        if (lArray == null) {
            for (int i = 0; i < n; ++i) {
                if (this.flipTriangle(i, lArray2) <= 0) continue;
                n2 += 2;
            }
        } else {
            int n3 = BitsUtil.nextSetBit(lArray, 0);
            while (n3 > -1) {
                if (this.flipTriangle(n3, lArray2) > 0) {
                    n2 += 2;
                }
                n3 = BitsUtil.nextSetBit(lArray, n3 + 1);
            }
        }
        return n2;
    }

    int flipTriangle(int n, long[] lArray) {
        int n2;
        int n3;
        int n4;
        Orientation orientation;
        Triangle triangle;
        int n5;
        Triangle triangle2 = this.tris.get(n);
        if (triangle2.ab >= 0) {
            n5 = triangle2.ab;
            triangle = this.tris.get(n5);
            orientation = triangle2.findOrientation(triangle);
            switch (orientation) {
                case ORIENT_AB_BA: {
                    n4 = triangle.c;
                    n3 = triangle.bc;
                    n2 = triangle.ca;
                    break;
                }
                case ORIENT_AB_CB: {
                    n4 = triangle.a;
                    n3 = triangle.ca;
                    n2 = triangle.ab;
                    break;
                }
                case ORIENT_AB_AC: {
                    n4 = triangle.b;
                    n3 = triangle.ab;
                    n2 = triangle.bc;
                    break;
                }
                default: {
                    throw new RuntimeException("Neighbor triangles not aligned?");
                }
            }
            if (triangle2.inCircle(this.points.get(n4))) {
                int n6 = triangle2.c;
                int n7 = triangle2.a;
                int n8 = n4;
                int n9 = triangle2.b;
                int n10 = triangle2.ca;
                int n11 = n3;
                int n12 = n2;
                int n13 = triangle2.bc;
                int n14 = n5;
                int n15 = n;
                triangle2.set(n6, n10, n7, n11, n8, n14);
                triangle2.updateCircumcircle(this.points);
                triangle.set(n8, n12, n9, n13, n6, n15);
                triangle.updateCircumcircle(this.points);
                if (n11 >= 0) {
                    this.tris.get(n11).replaceEdge(n8, n7, n5, n);
                }
                if (n13 >= 0) {
                    this.tris.get(n13).replaceEdge(n6, n9, n, n5);
                }
                BitsUtil.setI(lArray, n);
                BitsUtil.setI(lArray, n5);
                return n5;
            }
        }
        if (triangle2.bc >= 0) {
            n5 = triangle2.bc;
            triangle = this.tris.get(n5);
            orientation = triangle2.findOrientation(triangle);
            switch (orientation) {
                case ORIENT_BC_BA: {
                    n4 = triangle.c;
                    n3 = triangle.bc;
                    n2 = triangle.ca;
                    break;
                }
                case ORIENT_BC_CB: {
                    n4 = triangle.a;
                    n3 = triangle.ca;
                    n2 = triangle.ab;
                    break;
                }
                case ORIENT_BC_AC: {
                    n4 = triangle.b;
                    n3 = triangle.ab;
                    n2 = triangle.bc;
                    break;
                }
                default: {
                    throw new RuntimeException("Neighbor triangles not aligned?");
                }
            }
            if (triangle2.inCircle(this.points.get(n4))) {
                int n16 = triangle2.a;
                int n17 = triangle2.b;
                int n18 = n4;
                int n19 = triangle2.c;
                int n20 = triangle2.ab;
                int n21 = n3;
                int n22 = n2;
                int n23 = triangle2.ca;
                int n24 = n5;
                int n25 = n;
                triangle2.set(n16, n20, n17, n21, n18, n24);
                triangle2.updateCircumcircle(this.points);
                triangle.set(n18, n22, n19, n23, n16, n25);
                triangle.updateCircumcircle(this.points);
                if (n21 >= 0) {
                    this.tris.get(n21).replaceEdge(n18, n17, n5, n);
                }
                if (n23 >= 0) {
                    this.tris.get(n23).replaceEdge(n16, n19, n, n5);
                }
                BitsUtil.setI(lArray, n);
                BitsUtil.setI(lArray, n5);
                return n5;
            }
        }
        if (triangle2.ca >= 0) {
            n5 = triangle2.ca;
            triangle = this.tris.get(n5);
            orientation = triangle2.findOrientation(triangle);
            switch (orientation) {
                case ORIENT_CA_BA: {
                    n4 = triangle.c;
                    n3 = triangle.bc;
                    n2 = triangle.ca;
                    break;
                }
                case ORIENT_CA_CB: {
                    n4 = triangle.a;
                    n3 = triangle.ca;
                    n2 = triangle.ab;
                    break;
                }
                case ORIENT_CA_AC: {
                    n4 = triangle.b;
                    n3 = triangle.ab;
                    n2 = triangle.bc;
                    break;
                }
                default: {
                    throw new RuntimeException("Neighbor triangles not aligned?");
                }
            }
            if (triangle2.inCircle(this.points.get(n4))) {
                int n26 = triangle2.b;
                int n27 = triangle2.c;
                int n28 = n4;
                int n29 = triangle2.a;
                int n30 = triangle2.bc;
                int n31 = n3;
                int n32 = n2;
                int n33 = triangle2.ab;
                int n34 = n5;
                int n35 = n;
                triangle2.set(n26, n30, n27, n31, n28, n34);
                triangle2.updateCircumcircle(this.points);
                triangle.set(n28, n32, n29, n33, n26, n35);
                triangle.updateCircumcircle(this.points);
                if (n31 >= 0) {
                    this.tris.get(n31).replaceEdge(n28, n27, n5, n);
                }
                if (n33 >= 0) {
                    this.tris.get(n33).replaceEdge(n26, n29, n, n5);
                }
                BitsUtil.setI(lArray, n);
                BitsUtil.setI(lArray, n5);
                return n5;
            }
        }
        return -1;
    }

    public Polygon getHull() {
        if (this.hull == null) {
            this.run(true);
        }
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DoubleMinMax doubleMinMax2 = new DoubleMinMax();
        ArrayList<Vector> arrayList = new ArrayList<Vector>(this.hull.size());
        for (IntIntPair intIntPair : this.hull) {
            Vector vector = this.points.get(intIntPair.first);
            arrayList.add(vector);
            doubleMinMax.put(vector.get(0));
            doubleMinMax2.put(vector.get(1));
        }
        return new Polygon(arrayList, doubleMinMax.getMin(), doubleMinMax.getMax(), doubleMinMax2.getMin(), doubleMinMax2.getMax());
    }

    public ArrayList<Triangle> getDelaunay() {
        if (this.tris == null) {
            this.run(false);
        }
        return this.tris;
    }

    public static double quadraticEuclidean(Vector vector, Vector vector2) {
        double d = vector.get(0) - vector2.get(0);
        double d2 = vector.get(1) - vector2.get(1);
        return d * d + d2 * d2;
    }

    boolean leftOf(Vector vector, Vector vector2, Vector vector3) {
        double d = vector2.get(0) - vector.get(0);
        double d2 = vector2.get(1) - vector.get(1);
        double d3 = vector3.get(0) - vector.get(0);
        double d4 = vector3.get(1) - vector.get(1);
        double d5 = d * d4 - d2 * d3;
        return d5 > 0.0;
    }

    public static void main(String[] stringArray) {
        SweepHullDelaunay2D sweepHullDelaunay2D = new SweepHullDelaunay2D();
        Random random = new Random(1L);
        for (int i = 0; i < 100000; ++i) {
            Vector vector = new Vector(random.nextDouble(), random.nextDouble());
            sweepHullDelaunay2D.add(vector);
        }
        sweepHullDelaunay2D.run(false);
    }

    public static class Triangle {
        public int a;
        public int b;
        public int c;
        public int ab = -1;
        public int ca = -1;
        public int bc = -1;
        public double r2 = -1.0;
        public Vector m = new Vector(2);

        public Triangle(int n, int n2, int n3) {
            this.a = n;
            this.b = n2;
            this.c = n3;
        }

        void replaceEdge(int n, int n2, int n3, int n4) {
            if (this.a == n && this.b == n2) {
                assert (this.ab == n3) : "Edge doesn't match: " + this + " " + n + " " + n2 + " " + n3 + " " + n4;
                this.ab = n4;
                return;
            }
            if (this.b == n && this.c == n2) {
                assert (this.bc == n3) : "Edge doesn't match: " + this + " " + n + " " + n2 + " " + n3 + " " + n4;
                this.bc = n4;
                return;
            }
            if (this.c == n && this.a == n2) {
                assert (this.ca == n3) : "Edge doesn't match: " + this + " " + n + " " + n2 + " " + n3 + " " + n4;
                this.ca = n4;
                return;
            }
        }

        void set(int n, int n2, int n3, int n4, int n5, int n6) {
            this.a = n;
            this.ab = n2;
            this.b = n3;
            this.bc = n4;
            this.c = n5;
            this.ca = n6;
        }

        public boolean inCircle(Vector vector) {
            double d;
            double d2 = vector.get(0) - this.m.get(0);
            return d2 * d2 + (d = vector.get(1) - this.m.get(1)) * d <= this.r2;
        }

        Orientation findOrientation(Triangle triangle) {
            if (this.a == triangle.a) {
                if (this.b == triangle.c) {
                    return Orientation.ORIENT_AB_AC;
                }
                if (this.c == triangle.b) {
                    return Orientation.ORIENT_CA_BA;
                }
            }
            if (this.a == triangle.b) {
                if (this.b == triangle.a) {
                    return Orientation.ORIENT_AB_BA;
                }
                if (this.c == triangle.c) {
                    return Orientation.ORIENT_CA_CB;
                }
            }
            if (this.a == triangle.c) {
                if (this.b == triangle.b) {
                    return Orientation.ORIENT_AB_CB;
                }
                if (this.c == triangle.a) {
                    return Orientation.ORIENT_CA_AC;
                }
            }
            if (this.b == triangle.b && this.c == triangle.a) {
                return Orientation.ORIENT_BC_BA;
            }
            if (this.b == triangle.c && this.c == triangle.b) {
                return Orientation.ORIENT_BC_CB;
            }
            if (this.b == triangle.a && this.c == triangle.c) {
                return Orientation.ORIENT_BC_AC;
            }
            return null;
        }

        void makeClockwise(List<Vector> list) {
            if (!this.isClockwise(list)) {
                int n = this.b;
                this.b = this.c;
                this.c = n;
                n = this.ab;
                this.ab = this.ca;
                this.ca = n;
            }
        }

        boolean isClockwise(List<Vector> list) {
            double d;
            double d2 = (list.get(this.a).get(0) + list.get(this.b).get(0) + list.get(this.c).get(0)) / 3.0;
            double d3 = (list.get(this.a).get(1) + list.get(this.b).get(1) + list.get(this.c).get(1)) / 3.0;
            double d4 = list.get(this.a).get(0) - d2;
            double d5 = list.get(this.a).get(1) - d3;
            double d6 = list.get(this.b).get(0) - list.get(this.a).get(0);
            double d7 = -d6 * d5 + (d = list.get(this.b).get(1) - list.get(this.a).get(1)) * d4;
            return d7 <= 0.0;
        }

        void copyFrom(Triangle triangle) {
            this.a = triangle.a;
            this.b = triangle.b;
            this.c = triangle.c;
            this.r2 = triangle.r2;
            this.m.set(0, triangle.m.get(0));
            this.m.set(1, triangle.m.get(1));
        }

        boolean updateCircumcircle(List<Vector> list) {
            Vector vector = list.get(this.a);
            Vector vector2 = list.get(this.b);
            Vector vector3 = list.get(this.c);
            double d = vector2.get(0) - vector.get(0);
            double d2 = vector2.get(1) - vector.get(1);
            double d3 = vector3.get(0) - vector.get(0);
            double d4 = vector3.get(1) - vector.get(1);
            double d5 = d * d + d2 * d2;
            double d6 = d3 * d3 + d4 * d4;
            double d7 = 2.0 * (d * d4 - d2 * d3);
            if (d7 == 0.0) {
                return false;
            }
            double d8 = (d4 * d5 - d2 * d6) / d7;
            double d9 = (d * d6 - d3 * d5) / d7;
            this.r2 = d8 * d8 + d9 * d9;
            if (this.r2 > 1.0E10 * d5 || this.r2 > 1.0E10 * d6) {
                return false;
            }
            this.m.set(0, vector.get(0) + d8);
            this.m.set(1, vector.get(1) + d9);
            return true;
        }

        public String toString() {
            return "Triangle [a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", ab=" + this.ab + ", ac=" + this.ca + ", bc=" + this.bc + "]";
        }
    }

    static enum Orientation {
        ORIENT_AB_BA,
        ORIENT_AB_CB,
        ORIENT_AB_AC,
        ORIENT_BC_BA,
        ORIENT_BC_CB,
        ORIENT_BC_AC,
        ORIENT_CA_BA,
        ORIENT_CA_CB,
        ORIENT_CA_AC;

    }
}

