/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;

public class Centroid
extends Vector {
    protected double wsum = 0.0;

    public Centroid(int n) {
        super(n);
    }

    public void put(double[] dArray) {
        assert (dArray.length == this.elements.length);
        this.wsum += 1.0;
        int n = 0;
        while (n < this.elements.length) {
            double d = dArray[n] - this.elements[n];
            int n2 = n++;
            this.elements[n2] = this.elements[n2] + d / this.wsum;
        }
    }

    public void put(double[] dArray, double d) {
        assert (dArray.length == this.elements.length);
        if (d == 0.0) {
            return;
        }
        double d2 = d + this.wsum;
        int n = 0;
        while (n < this.elements.length) {
            double d3 = dArray[n] - this.elements[n];
            double d4 = d3 * d / d2;
            int n2 = n++;
            this.elements[n2] = this.elements[n2] + d4;
        }
        this.wsum = d2;
    }

    public final void put(Vector vector) {
        this.put(vector.getArrayRef());
    }

    public final void put(Vector vector, double d) {
        this.put(vector.getArrayRef(), d);
    }

    public void put(NumberVector numberVector) {
        assert (numberVector.getDimensionality() == this.elements.length);
        this.wsum += 1.0;
        int n = 0;
        while (n < this.elements.length) {
            double d = numberVector.doubleValue(n) - this.elements[n];
            int n2 = n++;
            this.elements[n2] = this.elements[n2] + d / this.wsum;
        }
    }

    public void put(NumberVector numberVector, double d) {
        assert (numberVector.getDimensionality() == this.elements.length);
        if (d == 0.0) {
            return;
        }
        double d2 = d + this.wsum;
        int n = 0;
        while (n < this.elements.length) {
            double d3 = numberVector.doubleValue(n) - this.elements[n];
            double d4 = d3 * d / d2;
            int n2 = n++;
            this.elements[n2] = this.elements[n2] + d4;
        }
        this.wsum = d2;
    }

    public <F extends NumberVector> F toVector(Relation<? extends F> relation) {
        return RelationUtil.getNumberVectorFactory(relation).newNumberVector(this.elements);
    }

    public static Centroid make(Matrix matrix) {
        Centroid centroid = new Centroid(matrix.getRowDimensionality());
        int n = matrix.getColumnDimensionality();
        for (int i = 0; i < n; ++i) {
            centroid.put(matrix.getCol(i));
        }
        return centroid;
    }

    public static Centroid make(Relation<? extends NumberVector> relation) {
        int n = RelationUtil.dimensionality(relation);
        Centroid centroid = new Centroid(n);
        double[] dArray = centroid.elements;
        int n2 = 0;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = relation.get(dBIDIter);
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + numberVector.doubleValue(i);
            }
            ++n2;
            dBIDIter.advance();
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] / (double)n2;
        }
        centroid.wsum = n2;
        return centroid;
    }

    public static Centroid make(Relation<? extends NumberVector> relation, DBIDs dBIDs) {
        int n = RelationUtil.dimensionality(relation);
        Centroid centroid = new Centroid(n);
        double[] dArray = centroid.elements;
        int n2 = 0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            NumberVector numberVector = relation.get(dBIDIter);
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + numberVector.doubleValue(i);
            }
            ++n2;
            dBIDIter.advance();
        }
        if (n2 == 0) {
            return centroid;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] / (double)n2;
        }
        centroid.wsum = n2;
        return centroid;
    }
}

