/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="J.R.M. Hosking, J. R. Wallis, and E. F. Wood", title="Estimation of the generalized extreme-value distribution by the method of probability-weighted moments.", booktitle="Technometrics 27.3", url="http://dx.doi.org/10.1080/00401706.1985.10488049")
public class ProbabilityWeightedMoments {
    public static <A> double[] alphaPWM(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        int n2 = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        double d = 1.0 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i);
            dArray[0] = dArray[0] + d * d2;
            int n3 = 1;
            while (n3 < n) {
                int n4 = n3++;
                dArray[n4] = dArray[n4] + (d *= (double)((n2 - i - n3 + 1) / (n2 - n3 + 1))) * d2;
            }
        }
        return dArray;
    }

    public static <A> double[] betaPWM(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        int n2 = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        double d = 1.0 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i);
            dArray[0] = dArray[0] + d * d2;
            int n3 = 1;
            while (n3 < n) {
                int n4 = n3++;
                dArray[n4] = dArray[n4] + (d *= (double)((i - n3 + 1) / (n2 - n3 + 1))) * d2;
            }
        }
        return dArray;
    }

    public static <A> double[] alphaBetaPWM(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        double d;
        int n2 = numberArrayAdapter.size(a);
        double[] dArray = new double[n << 1];
        double d2 = d = 1.0 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            double d3 = numberArrayAdapter.getDouble(a, i);
            dArray[0] = dArray[0] + d * d3;
            dArray[1] = dArray[1] + d2 * d3;
            int n3 = 1;
            int n4 = 2;
            while (n3 < n) {
                int n5 = n4 + 1;
                dArray[n5] = dArray[n5] + (d *= (double)((n2 - i - n3 + 1) / (n2 - n3 + 1))) * d3;
                int n6 = n4 + 1;
                dArray[n6] = dArray[n6] + (d2 *= (double)((i - n3 + 1) / (n2 - n3 + 1))) * d3;
                ++n3;
                n4 += 2;
            }
        }
        return dArray;
    }

    public static <A> double[] samLMR(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        int n2 = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        n = n2 < n ? n2 : n;
        for (int i = 0; i < n2; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            dArray[0] = dArray[0] + d;
            int n3 = 1;
            int n4 = i;
            while (n3 < n) {
                int n5 = n3++;
                dArray[n5] = dArray[n5] + (d *= (double)n4);
                --n4;
            }
        }
        dArray[0] = dArray[0] / (double)n2;
        double d = n2;
        int n6 = 1;
        while (n6 < n) {
            int n7 = n6++;
            dArray[n7] = dArray[n7] / (d *= (double)(n2 - n6));
        }
        for (n6 = n - 1; n6 >= 1; --n6) {
            double d2 = (n6 & 1) == 0 ? 1.0 : -1.0;
            double d3 = d2 * dArray[0];
            for (int i = 0; i < n6; ++i) {
                double d4 = (double)i + 1.0;
                d3 += (d2 *= -((double)n6 + d4) * (double)(n6 - i) / (d4 * d4)) * dArray[i + 1];
            }
            dArray[n6] = d3;
        }
        if (dArray[1] == 0.0) {
            for (n6 = 2; n6 < n; ++n6) {
                dArray[n6] = 0.0;
            }
            return dArray;
        }
        n6 = 2;
        while (n6 < n) {
            int n8 = n6++;
            dArray[n8] = dArray[n8] / dArray[1];
        }
        return dArray;
    }
}

