/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class ChiSquaredDistribution
extends GammaDistribution {
    public ChiSquaredDistribution(double d) {
        this(d, (Random)null);
    }

    public ChiSquaredDistribution(double d, Random random) {
        super(0.5 * d, 0.5, random);
    }

    public ChiSquaredDistribution(double d, RandomFactory randomFactory) {
        super(0.5 * d, 0.5, randomFactory);
    }

    public static double cdf(double d, double d2) {
        return ChiSquaredDistribution.regularizedGammaP(0.5 * d2, 0.5 * d);
    }

    public static double pdf(double d, double d2) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d3 = d2 * 0.5;
        if (Math.abs(d3 - 1.0) < Double.MIN_NORMAL) {
            return Math.exp(-d * 2.0) * 2.0;
        }
        return Math.exp((d3 - 1.0) * Math.log(d * 2.0) - d * 2.0 - ChiSquaredDistribution.logGamma(d3)) * 2.0;
    }

    @Reference(title="Algorithm AS 91: The percentage points of the $\\chi^2$ distribution", authors="D.J. Best, D. E. Roberts", booktitle="Journal of the Royal Statistical Society. Series C (Applied Statistics)")
    public static double quantile(double d, double d2) {
        return GammaDistribution.quantile(d, 0.5 * d2, 0.5);
    }

    @Override
    public String toString() {
        return "ChiSquaredDistribution(dof=" + 2.0 * this.getK() + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID DOF_ID = new OptionID("distribution.chi.dof", "Chi distribution degrees of freedom parameter.");
        double dof;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(DOF_ID);
            if (parameterization.grab(doubleParameter)) {
                this.dof = doubleParameter.doubleValue();
            }
        }

        @Override
        protected ChiSquaredDistribution makeInstance() {
            return new ChiSquaredDistribution(this.dof, this.rnd);
        }
    }
}

