/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class LogGammaDistribution
extends AbstractDistribution {
    private final double k;
    private final double theta;
    private final double shift;

    public LogGammaDistribution(double d, double d2, double d3, Random random) {
        super(random);
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + d + " " + d2);
        }
        this.k = d;
        this.theta = d2;
        this.shift = d3;
    }

    public LogGammaDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + d + " " + d2);
        }
        this.k = d;
        this.theta = d2;
        this.shift = d3;
    }

    public LogGammaDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return LogGammaDistribution.pdf(d, this.k, this.theta, this.shift);
    }

    @Override
    public double cdf(double d) {
        return LogGammaDistribution.cdf(d, this.k, this.theta, this.shift);
    }

    @Override
    public double quantile(double d) {
        return LogGammaDistribution.quantile(d, this.k, this.theta, this.shift);
    }

    @Override
    public double nextRandom() {
        return Math.exp(GammaDistribution.nextRandom(this.k, this.theta, this.random)) + this.shift;
    }

    @Override
    public String toString() {
        return "LogGammaDistribution(k=" + this.k + ", theta=" + this.theta + ", shift=" + this.shift + ")";
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if ((d -= d4) <= 1.0) {
            return 0.0;
        }
        return GammaDistribution.regularizedGammaP(d2, Math.log(d));
    }

    public static double logcdf(double d, double d2, double d3, double d4) {
        if ((d -= d4) <= 1.0) {
            return 0.0;
        }
        return GammaDistribution.logregularizedGammaP(d2, Math.log(d));
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        if ((d -= d4) <= 1.0) {
            return 0.0;
        }
        return Math.pow(d3, -d2) / GammaDistribution.gamma(d2) * Math.pow(d, -(1.0 / d3 + 1.0)) * Math.pow(Math.log(d), d2 - 1.0);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        return Math.exp(GammaDistribution.quantile(d, d2, d3)) + d4;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SHIFT_ID = new OptionID("distribution.loggamma.shift", "Shift offset parameter.");
        double k;
        double theta;
        double shift;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(GammaDistribution.Parameterizer.K_ID);
            if (parameterization.grab(doubleParameter3)) {
                this.k = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(GammaDistribution.Parameterizer.THETA_ID))) {
                this.theta = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHIFT_ID))) {
                this.shift = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LogGammaDistribution makeInstance() {
            return new LogGammaDistribution(this.k, this.theta, this.shift, this.rnd);
        }
    }
}

