/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Applied Robust Statistics", authors="D. J. Olive", booktitle="Applied Robust Statistics", url="http://lagrange.math.siu.edu/Olive/preprints.htm")
public class ExponentialMADEstimator
extends AbstractMADEstimator<ExponentialDistribution> {
    public static final ExponentialMADEstimator STATIC = new ExponentialMADEstimator();

    private ExponentialMADEstimator() {
    }

    @Override
    public ExponentialDistribution estimateFromMedianMAD(double d, double d2) {
        double d3 = d - 1.44 * d2;
        double d4 = 2.0781 * d2;
        if (!(d4 > 0.0)) {
            throw new ArithmeticException("Data with non-positive MAD cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / d4, d3);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

