/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.PolygonsObject;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.GrahamScanConvexHull2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierLinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@Reference(authors="E. Achtert, A. Hettab, H.-P. Kriegel, E. Schubert, A. Zimek", booktitle="Proc. 12th International Symposium on Spatial and Temporal Databases (SSTD), Minneapolis, MN, 2011", title="Spatial Outlier Detection: Data, Algorithms, Visualizations", url="http://dx.doi.org/10.1007/978-3-642-22922-0_41")
public class KMLOutputHandler
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(KMLOutputHandler.class);
    private static final int NUMSTYLES = 20;
    File filename;
    OutlierScalingFunction scaling;
    private boolean compat;
    private boolean autoopen;

    public KMLOutputHandler(File file, OutlierScalingFunction outlierScalingFunction, boolean bl, boolean bl2) {
        this.filename = file;
        this.scaling = outlierScalingFunction;
        this.compat = bl;
        this.autoopen = bl2;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        XMLStreamWriter xMLStreamWriter;
        ZipOutputStream zipOutputStream;
        XMLOutputFactory iOException;
        ArrayList<OutlierResult> arrayList = ResultUtil.filterResults(resultHierarchy, result, OutlierResult.class);
        ArrayList<Clustering> arrayList2 = ResultUtil.filterResults(resultHierarchy, result, Clustering.class);
        if (arrayList.size() + arrayList2.size() > 1) {
            throw new AbortException("More than one visualizable result found. The KML writer only supports a single result!");
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        for (OutlierResult basicResult : arrayList) {
            try {
                iOException = XMLOutputFactory.newInstance();
                zipOutputStream = new ZipOutputStream(new FileOutputStream(this.filename));
                zipOutputStream.putNextEntry(new ZipEntry("doc.kml"));
                xMLStreamWriter = iOException.createXMLStreamWriter(zipOutputStream);
                this.writeOutlierResult(xMLStreamWriter, basicResult, database);
                xMLStreamWriter.flush();
                xMLStreamWriter.close();
                zipOutputStream.closeEntry();
                zipOutputStream.flush();
                zipOutputStream.close();
                if (!this.autoopen) continue;
                Desktop.getDesktop().open(this.filename);
            }
            catch (XMLStreamException xMLStreamException) {
                LOG.exception(xMLStreamException);
                throw new AbortException("XML error in KML output.", xMLStreamException);
            }
            catch (IOException iOException2) {
                LOG.exception(iOException2);
                throw new AbortException("IO error in KML output.", iOException2);
            }
        }
        for (Clustering clustering : arrayList2) {
            try {
                iOException = XMLOutputFactory.newInstance();
                zipOutputStream = new ZipOutputStream(new FileOutputStream(this.filename));
                zipOutputStream.putNextEntry(new ZipEntry("doc.kml"));
                xMLStreamWriter = iOException.createXMLStreamWriter(zipOutputStream);
                Clustering clustering2 = clustering;
                this.writeClusteringResult(xMLStreamWriter, clustering2, database);
                xMLStreamWriter.flush();
                xMLStreamWriter.close();
                zipOutputStream.closeEntry();
                zipOutputStream.flush();
                zipOutputStream.close();
                if (!this.autoopen) continue;
                Desktop.getDesktop().open(this.filename);
            }
            catch (XMLStreamException xMLStreamException) {
                LOG.exception(xMLStreamException);
                throw new AbortException("XML error in KML output.", xMLStreamException);
            }
            catch (IOException iOException3) {
                LOG.exception(iOException3);
                throw new AbortException("IO error in KML output.", iOException3);
            }
        }
    }

    private void writeOutlierResult(XMLStreamWriter xMLStreamWriter, OutlierResult outlierResult, Database database) throws XMLStreamException {
        Serializable serializable;
        Relation relation = database.getRelation(TypeUtil.POLYGON_TYPE, new Object[0]);
        Relation<String> relation2 = DatabaseUtil.guessObjectLabelRepresentation(database);
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeCharacters("\n");
        xMLStreamWriter.writeStartElement("kml");
        xMLStreamWriter.writeDefaultNamespace("http://earth.google.com/kml/2.2");
        xMLStreamWriter.writeStartElement("Document");
        xMLStreamWriter.writeStartElement("name");
        xMLStreamWriter.writeCharacters("ELKI KML output for " + outlierResult.getLongName());
        xMLStreamWriter.writeEndElement();
        this.writeNewlineOnDebug(xMLStreamWriter);
        xMLStreamWriter.writeStartElement("description");
        xMLStreamWriter.writeCharacters("ELKI KML output for " + outlierResult.getLongName());
        xMLStreamWriter.writeEndElement();
        this.writeNewlineOnDebug(xMLStreamWriter);
        for (int i = 0; i < 20; ++i) {
            serializable = KMLOutputHandler.getColorForValue((double)i / 19.0);
            xMLStreamWriter.writeStartElement("Style");
            xMLStreamWriter.writeAttribute("id", "s" + i);
            this.writeNewlineOnDebug(xMLStreamWriter);
            xMLStreamWriter.writeStartElement("LineStyle");
            xMLStreamWriter.writeStartElement("width");
            xMLStreamWriter.writeCharacters("0");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            this.writeNewlineOnDebug(xMLStreamWriter);
            xMLStreamWriter.writeStartElement("PolyStyle");
            xMLStreamWriter.writeStartElement("color");
            xMLStreamWriter.writeCharacters(String.format("%02x%02x%02x%02x", ((Color)serializable).getAlpha(), ((Color)serializable).getBlue(), ((Color)serializable).getGreen(), ((Color)serializable).getRed()));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("outline");
            xMLStreamWriter.writeCharacters("0");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            this.writeNewlineOnDebug(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            this.writeNewlineOnDebug(xMLStreamWriter);
        }
        DoubleRelation doubleRelation = outlierResult.getScores();
        serializable = new LinkedList(database.getRelations());
        serializable.remove(doubleRelation);
        serializable.remove(relation);
        serializable.remove(relation2);
        serializable.remove(database.getRelation(TypeUtil.DBID, new Object[0]));
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(doubleRelation.getDBIDs());
        this.scaling.prepare(outlierResult);
        DBIDArrayMIter dBIDArrayMIter = outlierResult.getOrdering().order(arrayModifiableDBIDs).iter();
        while (dBIDArrayMIter.valid()) {
            double d = doubleRelation.doubleValue(dBIDArrayMIter);
            PolygonsObject polygonsObject = (PolygonsObject)relation.get(dBIDArrayMIter);
            String string = relation2.get(dBIDArrayMIter);
            if (Double.isNaN(d)) {
                LOG.warning("No score for object " + DBIDUtil.toString(dBIDArrayMIter));
            }
            if (polygonsObject == null) {
                LOG.warning("No polygon for object " + DBIDUtil.toString(dBIDArrayMIter) + " - skipping.");
            } else {
                xMLStreamWriter.writeStartElement("Placemark");
                xMLStreamWriter.writeStartElement("name");
                xMLStreamWriter.writeCharacters(d + " " + string);
                xMLStreamWriter.writeEndElement();
                StringBuilder stringBuilder = this.makeDescription((Collection<Relation<?>>)((Object)serializable), dBIDArrayMIter);
                xMLStreamWriter.writeStartElement("description");
                xMLStreamWriter.writeCData("<div>" + stringBuilder.toString() + "</div>");
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeStartElement("styleUrl");
                int n = (int)(this.scaling.getScaled(d) * 20.0);
                n = Math.max(0, Math.min(n, 19));
                xMLStreamWriter.writeCharacters("#s" + n);
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeStartElement("Polygon");
                this.writeNewlineOnDebug(xMLStreamWriter);
                if (this.compat) {
                    xMLStreamWriter.writeStartElement("altitudeMode");
                    xMLStreamWriter.writeCharacters("relativeToGround");
                    xMLStreamWriter.writeEndElement();
                    this.writeNewlineOnDebug(xMLStreamWriter);
                }
                boolean bl = true;
                for (Polygon polygon : polygonsObject.getPolygons()) {
                    if (bl) {
                        xMLStreamWriter.writeStartElement("outerBoundaryIs");
                    } else {
                        xMLStreamWriter.writeStartElement("innerBoundaryIs");
                    }
                    xMLStreamWriter.writeStartElement("LinearRing");
                    xMLStreamWriter.writeStartElement("coordinates");
                    boolean bl2 = polygon.testClockwise() >= 0;
                    ArrayListIter<Vector> arrayListIter = polygon.iter();
                    if (bl2) {
                        arrayListIter.seek(polygon.size() - 1);
                    }
                    while (arrayListIter.valid()) {
                        Vector vector = arrayListIter.get();
                        xMLStreamWriter.writeCharacters(FormatUtil.format(vector.getArrayRef(), ","));
                        if (this.compat && vector.getDimensionality() == 2) {
                            xMLStreamWriter.writeCharacters(",50");
                        }
                        xMLStreamWriter.writeCharacters(" ");
                        if (!bl2) {
                            arrayListIter.advance();
                            continue;
                        }
                        arrayListIter.retract();
                    }
                    xMLStreamWriter.writeEndElement();
                    xMLStreamWriter.writeEndElement();
                    xMLStreamWriter.writeEndElement();
                    bl = false;
                }
                this.writeNewlineOnDebug(xMLStreamWriter);
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
                this.writeNewlineOnDebug(xMLStreamWriter);
            }
            dBIDArrayMIter.advance();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
    }

    private void writeClusteringResult(XMLStreamWriter xMLStreamWriter, Clustering<Model> clustering, Database database) throws XMLStreamException {
        Object object;
        Object object2;
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeCharacters("\n");
        xMLStreamWriter.writeStartElement("kml");
        xMLStreamWriter.writeDefaultNamespace("http://earth.google.com/kml/2.2");
        xMLStreamWriter.writeStartElement("Document");
        xMLStreamWriter.writeStartElement("name");
        xMLStreamWriter.writeCharacters("ELKI KML output for " + clustering.getLongName());
        xMLStreamWriter.writeEndElement();
        this.writeNewlineOnDebug(xMLStreamWriter);
        xMLStreamWriter.writeStartElement("description");
        xMLStreamWriter.writeCharacters("ELKI KML output for " + clustering.getLongName());
        xMLStreamWriter.writeEndElement();
        this.writeNewlineOnDebug(xMLStreamWriter);
        List<Cluster<Model>> list = clustering.getAllClusters();
        Relation relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD_2D, new Object[0]);
        List<Cluster<Model>> list2 = clustering.getToplevelClusters();
        Hierarchy<Cluster<Model>> hierarchy = clustering.getClusterHierarchy();
        HashMap<Object, DoubleObjPair<Polygon>> hashMap = new HashMap<Object, DoubleObjPair<Polygon>>();
        for (Cluster<Model> object32 : list2) {
            this.buildHullsRecursively(object32, hierarchy, hashMap, relation);
        }
        Iterator<Cluster<Model>> n2 = list.iterator();
        int cluster = 0;
        while (n2.hasNext()) {
            object2 = n2.next();
            Color bl = Color.getHSBColor((float)cluster / 4.294967f, 1.0f, 0.5f);
            object = (DoubleObjPair)hashMap.get(object2);
            double vector = SpatialUtil.volume((SpatialComparable)((DoubleObjPair)object).second);
            double d = Math.max(1.0 - vector / 648.0, 0.0);
            double d2 = 0.65 * Math.sqrt(d) + 0.1;
            xMLStreamWriter.writeStartElement("Style");
            xMLStreamWriter.writeAttribute("id", "s" + cluster);
            this.writeNewlineOnDebug(xMLStreamWriter);
            xMLStreamWriter.writeStartElement("LineStyle");
            xMLStreamWriter.writeStartElement("width");
            xMLStreamWriter.writeCharacters("0");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            this.writeNewlineOnDebug(xMLStreamWriter);
            xMLStreamWriter.writeStartElement("PolyStyle");
            xMLStreamWriter.writeStartElement("color");
            xMLStreamWriter.writeCharacters(String.format("%02x%02x%02x%02x", (int)(255.0 * Math.min(0.75, d2)), bl.getBlue(), bl.getGreen(), bl.getRed()));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("outline");
            xMLStreamWriter.writeCharacters("0");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            this.writeNewlineOnDebug(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            this.writeNewlineOnDebug(xMLStreamWriter);
            ++cluster;
        }
        Iterator<Cluster<Model>> iterator2 = list2.size() == 1 ? list2.get(0) : null;
        Iterator<Cluster<Model>> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Cluster<Model> cluster2 = iterator.next();
            if (cluster2 != iterator2) {
                object2 = (Polygon)((DoubleObjPair)hashMap.get(cluster2)).second;
                xMLStreamWriter.writeStartElement("Placemark");
                xMLStreamWriter.writeStartElement("name");
                xMLStreamWriter.writeCharacters(cluster2.getNameAutomatic());
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeStartElement("description");
                xMLStreamWriter.writeCData(this.makeDescription(cluster2).toString());
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeStartElement("styleUrl");
                xMLStreamWriter.writeCharacters("#s" + n);
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeStartElement("Polygon");
                this.writeNewlineOnDebug(xMLStreamWriter);
                if (this.compat) {
                    xMLStreamWriter.writeStartElement("altitudeMode");
                    xMLStreamWriter.writeCharacters("relativeToGround");
                    xMLStreamWriter.writeEndElement();
                    this.writeNewlineOnDebug(xMLStreamWriter);
                }
                xMLStreamWriter.writeStartElement("outerBoundaryIs");
                xMLStreamWriter.writeStartElement("LinearRing");
                xMLStreamWriter.writeStartElement("coordinates");
                boolean bl = ((Polygon)object2).testClockwise() >= 0;
                object = ((Polygon)object2).iter();
                if (bl) {
                    ((ArrayListIter)object).seek(((Polygon)object2).size() - 1);
                }
                while (((ArrayListIter)object).valid()) {
                    Vector vector = (Vector)((ArrayListIter)object).get();
                    xMLStreamWriter.writeCharacters(FormatUtil.format(vector.getArrayRef(), ","));
                    if (this.compat && vector.getDimensionality() == 2) {
                        xMLStreamWriter.writeCharacters(",100");
                    }
                    xMLStreamWriter.writeCharacters(" ");
                    if (!bl) {
                        ((ArrayListIter)object).advance();
                        continue;
                    }
                    ((ArrayListIter)object).retract();
                }
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
                this.writeNewlineOnDebug(xMLStreamWriter);
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndElement();
                this.writeNewlineOnDebug(xMLStreamWriter);
            }
            ++n;
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
    }

    private DoubleObjPair<Polygon> buildHullsRecursively(Cluster<Model> cluster, Hierarchy<Cluster<Model>> hierarchy, Map<Object, DoubleObjPair<Polygon>> map, Relation<? extends NumberVector> relation) {
        int n;
        DBIDs dBIDs = cluster.getIDs();
        GrahamScanConvexHull2D grahamScanConvexHull2D = new GrahamScanConvexHull2D();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            grahamScanConvexHull2D.add(relation.get(dBIDIter).getColumnVector());
            dBIDIter.advance();
        }
        double d = dBIDs.size();
        if (hierarchy != null && map != null && (n = hierarchy.numChildren(cluster)) > 0) {
            Hierarchy.Iter<Cluster<Model>> iter = hierarchy.iterChildren(cluster);
            while (iter.valid()) {
                Cluster<Model> cluster2 = iter.get();
                DoubleObjPair<Polygon> doubleObjPair = map.get(cluster2);
                if (doubleObjPair == null) {
                    doubleObjPair = this.buildHullsRecursively(cluster2, hierarchy, map, relation);
                }
                ArrayListIter<Vector> arrayListIter = ((Polygon)doubleObjPair.second).iter();
                while (arrayListIter.valid()) {
                    grahamScanConvexHull2D.add(arrayListIter.get());
                    arrayListIter.advance();
                }
                d += doubleObjPair.first / (double)n;
                iter.advance();
            }
        }
        DoubleObjPair<Polygon> doubleObjPair = new DoubleObjPair<Polygon>(d, grahamScanConvexHull2D.getHull());
        map.put(cluster, doubleObjPair);
        return doubleObjPair;
    }

    private StringBuilder makeDescription(Collection<Relation<?>> collection, DBIDRef dBIDRef) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Relation<?> relation : collection) {
            String string;
            Object obj = relation.get(dBIDRef);
            if (obj == null || (string = obj.toString()) == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br />");
            }
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    private StringBuilder makeDescription(Cluster<?> cluster) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div>");
        stringBuilder.append(cluster.getNameAutomatic());
        stringBuilder.append("<br />");
        stringBuilder.append("Size: " + cluster.size());
        stringBuilder.append("</div>");
        return stringBuilder;
    }

    private void writeNewlineOnDebug(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (LOG.isDebugging()) {
            xMLStreamWriter.writeCharacters("\n");
        }
    }

    public static final Color getColorForValue(double d) {
        double[] dArray = new double[]{0.0, 0.6, 0.8, 1.0};
        Color[] colorArray = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 1.0f, 0.8f), new Color(1.0f, 0.0f, 0.0f, 0.9f), new Color(1.0f, 1.0f, 0.0f, 1.0f)};
        assert (dArray.length == colorArray.length);
        if (d < dArray[0]) {
            d = dArray[0];
        }
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d <= dArray[i])) continue;
            Color color = colorArray[i - 1];
            Color color2 = colorArray[i];
            double d2 = (d - dArray[i - 1]) / (dArray[i] - dArray[i - 1]);
            int n = (int)((1.0 - d2) * (double)color.getRed() + d2 * (double)color2.getRed());
            int n2 = (int)((1.0 - d2) * (double)color.getGreen() + d2 * (double)color2.getGreen());
            int n3 = (int)((1.0 - d2) * (double)color.getBlue() + d2 * (double)color2.getBlue());
            int n4 = (int)((1.0 - d2) * (double)color.getAlpha() + d2 * (double)color2.getAlpha());
            Color color3 = new Color(n, n2, n3, n4);
            return color3;
        }
        return colorArray[colorArray.length - 1];
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SCALING_ID = new OptionID("kml.scaling", "Additional scaling function for KML colorization.");
        public static final OptionID COMPAT_ID = new OptionID("kml.compat", "Use simpler KML objects, compatibility mode.");
        public static final OptionID AUTOOPEN_ID = new OptionID("kml.autoopen", "Automatically open the result file.");
        File filename;
        OutlierScalingFunction scaling;
        boolean compat;
        boolean autoopen = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            Flag flag2;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(OutputStep.Parameterizer.OUTPUT_ID, FileParameter.FileType.OUTPUT_FILE);
            fileParameter.setShortDescription("Filename the KMZ file (compressed KML) is written to.");
            if (parameterization.grab(fileParameter)) {
                this.filename = (File)fileParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(SCALING_ID, (Class<?>)OutlierScalingFunction.class, OutlierLinearScaling.class))) {
                this.scaling = (OutlierScalingFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag2 = new Flag(COMPAT_ID))) {
                this.compat = (Boolean)flag2.getValue();
            }
            if (parameterization.grab(flag = new Flag(AUTOOPEN_ID))) {
                this.autoopen = (Boolean)flag.getValue();
            }
        }

        @Override
        protected KMLOutputHandler makeInstance() {
            return new KMLOutputHandler(this.filename, this.scaling, this.compat, this.autoopen);
        }
    }
}

