/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.ConvertToStringView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static Relation<String> guessLabelRepresentation(Database database) throws NoSupportedDataTypeException {
        Relation<String> relation;
        try {
            relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            if (relation != null) {
                return new ConvertToStringView(relation);
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        try {
            relation = database.getRelation(TypeUtil.LABELLIST, new Object[0]);
            if (relation != null) {
                return new ConvertToStringView(relation);
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        try {
            relation = database.getRelation(TypeUtil.STRING, new Object[0]);
            if (relation != null) {
                return relation;
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        throw new NoSupportedDataTypeException("No label-like representation was found.");
    }

    public static Relation<String> guessObjectLabelRepresentation(Database database) throws NoSupportedDataTypeException {
        Relation<String> relation;
        try {
            relation = database.getRelation(TypeUtil.LABELLIST, new Object[0]);
            if (relation != null) {
                return new ConvertToStringView(relation);
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        try {
            relation = database.getRelation(TypeUtil.STRING, new Object[0]);
            if (relation != null) {
                return relation;
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        try {
            relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            if (relation != null) {
                return new ConvertToStringView(relation);
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        throw new NoSupportedDataTypeException("No label-like representation was found.");
    }

    public static SortedSet<ClassLabel> getClassLabels(Relation<? extends ClassLabel> relation) {
        TreeSet<ClassLabel> treeSet = new TreeSet<ClassLabel>();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            treeSet.add(relation.get(dBIDIter));
            dBIDIter.advance();
        }
        return treeSet;
    }

    public static SortedSet<ClassLabel> getClassLabels(Database database) {
        Relation relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
        return DatabaseUtil.getClassLabels(relation);
    }

    public static ArrayModifiableDBIDs getObjectsByLabelMatch(Database database, Pattern pattern) {
        Relation<String> relation = DatabaseUtil.guessLabelRepresentation(database);
        if (pattern == null) {
            return DBIDUtil.newArray();
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            if (pattern.matcher(relation.get(dBIDIter)).find()) {
                arrayModifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
        return arrayModifiableDBIDs;
    }

    public static <O> KNNQuery<O> precomputedKNNQuery(Database database, Relation<O> relation, DistanceQuery<O> distanceQuery, int n) {
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, n, "heavy", "optimized", "no-cache");
        if (kNNQuery instanceof PreprocessorKNNQuery) {
            return kNNQuery;
        }
        MaterializeKNNPreprocessor<O> materializeKNNPreprocessor = new MaterializeKNNPreprocessor<O>(relation, distanceQuery.getDistanceFunction(), n);
        materializeKNNPreprocessor.initialize();
        return materializeKNNPreprocessor.getKNNQuery(distanceQuery, n);
    }

    public static <O> KNNQuery<O> precomputedKNNQuery(Database database, Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, distanceFunction, new Object[0]);
        KNNQuery<? super O> kNNQuery = database.getKNNQuery(distanceQuery, n, "heavy", "optimized", "no-cache");
        if (kNNQuery instanceof PreprocessorKNNQuery) {
            return kNNQuery;
        }
        MaterializeKNNPreprocessor<O> materializeKNNPreprocessor = new MaterializeKNNPreprocessor<O>(relation, distanceQuery.getDistanceFunction(), n);
        materializeKNNPreprocessor.initialize();
        return materializeKNNPreprocessor.getKNNQuery(distanceQuery, n);
    }
}

