/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class FormatUtil {
    public static final NumberFormat NF = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF0 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF2 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF3 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF4 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF6 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF8 = NumberFormat.getInstance(Locale.US);
    private static final String WHITESPACE_BUFFER = "                                                                                ";
    public static final String NEWLINE;
    public static final String NONBREAKING_SPACE = "\u00a0";
    private static final long[] TIME_UNIT_SIZES;
    private static final String[] TIME_UNIT_NAMES;
    private static final int[] TIME_UNIT_DIGITS;
    private static final NumberFormatException EMPTY_STRING;
    private static final NumberFormatException EXPONENT_OVERFLOW;
    private static final NumberFormatException INVALID_EXPONENT;
    private static final NumberFormatException TRAILING_CHARACTERS;
    private static final NumberFormatException PRECISION_OVERFLOW;
    private static final NumberFormatException NOT_A_NUMBER;
    private static final long MAX_LONG_OVERFLOW = 0xCCCCCCCCCCCCCCCL;
    private static final int MAX_INT_OVERFLOW = 0xCCCCCCC;
    private static final char[] INFINITY_PATTERN;
    private static final int INFINITY_LENGTH;
    private static final char[] ZEROPADDING;
    private static final char[] SPACEPADDING;

    public static NumberFormat makeNumberFormat(int n) {
        switch (n) {
            case 0: {
                return NF0;
            }
            case 2: {
                return NF2;
            }
            case 3: {
                return NF3;
            }
            case 4: {
                return NF4;
            }
            case 6: {
                return NF6;
            }
            case 8: {
                return NF8;
            }
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public static String format(double[] dArray, String string) {
        if (dArray.length == 0) {
            return "";
        }
        return FormatUtil.formatTo(new StringBuilder(), dArray, string).toString();
    }

    public static String format(double[] dArray, NumberFormat numberFormat) {
        return FormatUtil.format(dArray, " ", numberFormat);
    }

    public static String format(double[] dArray, String string, NumberFormat numberFormat) {
        if (dArray.length == 0) {
            return "";
        }
        return FormatUtil.formatTo(new StringBuilder(), dArray, string, numberFormat).toString();
    }

    public static StringBuilder formatTo(StringBuilder stringBuilder, double[] dArray, String string) {
        if (dArray.length == 0) {
            return stringBuilder;
        }
        stringBuilder.append(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(dArray[i]);
        }
        return stringBuilder;
    }

    public static StringBuilder formatTo(StringBuilder stringBuilder, double[] dArray, String string, NumberFormat numberFormat) {
        if (dArray.length == 0) {
            return stringBuilder;
        }
        stringBuilder.append(numberFormat.format(dArray[0]));
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(numberFormat.format(dArray[i]));
        }
        return stringBuilder;
    }

    public static String format(double[] dArray) {
        return FormatUtil.formatTo(new StringBuilder(), dArray, ", ").toString();
    }

    public static String format(double[][] dArray) {
        return FormatUtil.format(dArray, "\n", ", ", NF2);
    }

    public static String format(double[][] dArray, String string, String string2, NumberFormat numberFormat) {
        if (dArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        FormatUtil.formatTo(stringBuilder, dArray[0], string2, numberFormat);
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append(string);
            FormatUtil.formatTo(stringBuilder, dArray[i], string2, numberFormat);
        }
        return stringBuilder.toString();
    }

    public static String format(float[] fArray, String string, NumberFormat numberFormat) {
        if (fArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(numberFormat.format(fArray[0]));
        for (int i = 1; i < fArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(numberFormat.format(fArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String format(float[] fArray) {
        return FormatUtil.format(fArray, ", ", NF2);
    }

    public static StringBuilder formatTo(StringBuilder stringBuilder, int[] nArray, String string) {
        if (nArray.length == 0) {
            return stringBuilder;
        }
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder;
    }

    public static String format(int[] nArray, String string) {
        return nArray == null ? "null" : (nArray.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), nArray, string).toString());
    }

    public static String format(int[] nArray) {
        return FormatUtil.format(nArray, ", ");
    }

    public static String format(long[] lArray) {
        if (lArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String format(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(byArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String format(boolean[] blArray, String string) {
        if (blArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FormatUtil.format(blArray[0]));
        for (int i = 1; i < blArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(FormatUtil.format(blArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String format(boolean bl) {
        return bl ? "1" : "0";
    }

    public static String format(long[] lArray, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BitsUtil.get(lArray, 0) ? (char)'1' : '0');
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(BitsUtil.get(lArray, i) ? (char)'1' : '0');
        }
        return stringBuilder.toString();
    }

    public static String format(int n, long[] lArray) {
        return FormatUtil.format(lArray, n, ",");
    }

    public static String format(Collection<String> collection, String string) {
        if (collection.size() == 0) {
            return "";
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public static String format(Matrix matrix, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        int n3 = n + 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i = 0; i < matrix.getRowDimensionality(); ++i) {
            for (int j = 0; j < matrix.getColumnDimensionality(); ++j) {
                String string = decimalFormat.format(matrix.get(i, j));
                int n4 = Math.max(1, n3 - string.length());
                for (int k = 0; k < n4; ++k) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String format(Vector vector, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        int n3 = n + 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i = 0; i < vector.getDimensionality(); ++i) {
            String string = decimalFormat.format(vector.get(i));
            int n4 = Math.max(1, n3 - string.length());
            for (int j = 0; j < n4; ++j) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String format(Matrix matrix, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("[\n").append(string);
        for (int i = 0; i < matrix.getRowDimensionality(); ++i) {
            stringBuilder.append(" [");
            for (int j = 0; j < matrix.getColumnDimensionality(); ++j) {
                stringBuilder.append(' ').append(matrix.get(i, j));
                if (j >= matrix.getColumnDimensionality() - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(" ]\n").append(string);
        }
        stringBuilder.append("]\n").append(string);
        return stringBuilder.toString();
    }

    public static String format(Matrix matrix, NumberFormat numberFormat) {
        int n;
        int[] nArray = new int[matrix.getColumnDimensionality()];
        String[][] stringArray = new String[matrix.getRowDimensionality()][matrix.getColumnDimensionality()];
        for (int i = 0; i < matrix.getRowDimensionality(); ++i) {
            for (n = 0; n < matrix.getColumnDimensionality(); ++n) {
                stringArray[i][n] = numberFormat.format(matrix.get(i, n));
                if (stringArray[i][n].length() <= nArray[n]) continue;
                nArray[n] = stringArray[i][n].length();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        for (n = 0; n < matrix.getRowDimensionality(); ++n) {
            stringBuilder.append(" [");
            for (int i = 0; i < matrix.getColumnDimensionality(); ++i) {
                stringBuilder.append(' ');
                int n2 = nArray[i] - stringArray[n][i].length();
                for (int j = 0; j < n2; ++j) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(stringArray[n][i]);
                if (i >= matrix.getColumnDimensionality() - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(" ]\n");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    public static String format(Matrix matrix) {
        return FormatUtil.format(matrix, NF);
    }

    public static String format(Vector vector, NumberFormat numberFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        FormatUtil.formatTo(stringBuilder, vector.getArrayRef(), ", ", numberFormat);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String format(Vector vector) {
        return FormatUtil.format(vector.getArrayRef());
    }

    public static String format(Vector vector, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("[\n").append(string);
        for (int i = 0; i < vector.getDimensionality(); ++i) {
            stringBuilder.append(' ').append(vector.get(i));
            if (i >= vector.getDimensionality() - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("]\n").append(string);
        return stringBuilder.toString();
    }

    public static String format(Matrix matrix, String string, NumberFormat numberFormat) {
        int n;
        if (numberFormat == null) {
            return FormatUtil.format(matrix, string);
        }
        int[] nArray = new int[matrix.getColumnDimensionality()];
        String[][] stringArray = new String[matrix.getRowDimensionality()][matrix.getColumnDimensionality()];
        for (int i = 0; i < matrix.getRowDimensionality(); ++i) {
            for (n = 0; n < matrix.getColumnDimensionality(); ++n) {
                stringArray[i][n] = numberFormat.format(matrix.get(i, n));
                if (stringArray[i][n].length() <= nArray[n]) continue;
                nArray[n] = stringArray[i][n].length();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("[\n").append(string);
        for (n = 0; n < matrix.getRowDimensionality(); ++n) {
            stringBuilder.append(" [");
            for (int i = 0; i < matrix.getColumnDimensionality(); ++i) {
                stringBuilder.append(' ');
                int n2 = nArray[i] - stringArray[n][i].length();
                for (int j = 0; j < n2; ++j) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(stringArray[n][i]);
                if (i >= matrix.getColumnDimensionality() - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(" ]\n").append(string);
        }
        stringBuilder.append("]\n").append(string);
        return stringBuilder.toString();
    }

    public static int findSplitpoint(String string, int n) {
        int n2 = string.indexOf(NEWLINE);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 < n) {
            return n2;
        }
        int n3 = string.lastIndexOf(32, n);
        if (n3 >= 0 && n3 < n) {
            return n3;
        }
        int n4 = FormatUtil.nextPosition(string.indexOf(32, n), string.indexOf(NEWLINE, n));
        if (n4 >= 0) {
            return n4;
        }
        return string.length();
    }

    private static int nextPosition(int n, int n2) {
        if (n < 0) {
            return n2;
        }
        if (n2 < 0) {
            return n;
        }
        return Math.min(n, n2);
    }

    public static List<String> splitAtLastBlank(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        while (string2.length() > 0) {
            int n2;
            arrayList.add(string2.substring(0, n2));
            for (n2 = FormatUtil.findSplitpoint(string2, n); n2 < string2.length() && string2.charAt(n2) == ' '; ++n2) {
            }
            if (n2 < string2.length() && string2.regionMatches(n2, NEWLINE, 0, NEWLINE.length())) {
                n2 += NEWLINE.length();
            }
            if (n2 >= string2.length()) break;
            string2 = string2.substring(n2);
        }
        return arrayList;
    }

    public static String whitespace(int n) {
        if (n < WHITESPACE_BUFFER.length()) {
            return WHITESPACE_BUFFER.substring(0, n);
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = WHITESPACE_BUFFER.charAt(0);
        }
        return new String(cArray);
    }

    public static String pad(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        return string + FormatUtil.whitespace(n - string.length());
    }

    public static String padRightAligned(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        return FormatUtil.whitespace(n - string.length()) + string;
    }

    public static int getConsoleWidth() {
        try {
            return Integer.parseInt(System.getenv("COLUMNS")) - 1;
        }
        catch (SecurityException securityException) {
            return 78;
        }
        catch (NumberFormatException numberFormatException) {
            return 78;
        }
    }

    public static String formatTimeDelta(long l, CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        for (int i = TIME_UNIT_SIZES.length - 1; i >= 0; --i) {
            if (i == 0 && stringBuilder.length() > 4) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(charSequence);
            }
            long l2 = l / TIME_UNIT_SIZES[i];
            l %= TIME_UNIT_SIZES[i];
            if (l2 == 0L && stringBuilder.length() == 0) continue;
            formatter.format("%0" + TIME_UNIT_DIGITS[i] + "d%s", l2, TIME_UNIT_NAMES[i]);
        }
        formatter.close();
        return stringBuilder.toString();
    }

    public static String format(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string).append(stringArray[i]);
                continue;
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static double parseDouble(CharSequence charSequence) {
        return FormatUtil.parseDouble(charSequence, 0, charSequence.length());
    }

    public static double parseDouble(CharSequence charSequence, int n, int n2) {
        int n3;
        boolean bl;
        if (n >= n2) {
            throw EMPTY_STRING;
        }
        int n4 = n;
        char c = charSequence.charAt(n4);
        if (FormatUtil.matchNaN(charSequence, c, n4, n2)) {
            return Double.NaN;
        }
        boolean bl2 = bl = c == '-';
        if ((bl || c == '+') && ++n4 < n2) {
            c = charSequence.charAt(n4);
        }
        if (FormatUtil.matchInf(charSequence, c, n4, n2)) {
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if ((c < '0' || c > '9') && c != '.') {
            throw NOT_A_NUMBER;
        }
        long l = 0L;
        int n5 = -1;
        while (true) {
            if ((n3 = c - 48) >= 0 && n3 <= 9) {
                long l2 = (l << 3) + (l << 1) + (long)n3;
                if (l > 0xCCCCCCCCCCCCCCCL || l2 < l) {
                    throw PRECISION_OVERFLOW;
                }
                l = l2;
            } else {
                if (c != '.' || n5 >= 0) break;
                n5 = n4;
            }
            if (++n4 >= n2) break;
            c = charSequence.charAt(n4);
        }
        n5 = n5 >= 0 ? n4 - n5 - 1 : 0;
        n3 = 0;
        if (n4 + 1 < n2 && (c == 'E' || c == 'e')) {
            int n6;
            boolean bl3;
            boolean bl4 = bl3 = (c = charSequence.charAt(++n4)) == '-';
            if ((bl3 || c == '+') && ++n4 < n2) {
                c = charSequence.charAt(n4);
            }
            if (c < '0' || c > '9') {
                throw INVALID_EXPONENT;
            }
            while ((n6 = c - 48) >= 0 && n6 < 10) {
                int n7 = (n3 << 3) + (n3 << 1) + n6;
                if (n3 > 0xCCCCCCC || n7 < n3) {
                    throw EXPONENT_OVERFLOW;
                }
                n3 = n7;
                if (++n4 >= n2) break;
                c = charSequence.charAt(n4);
            }
            if (bl3) {
                n3 = -n3;
            }
        }
        if (n5 >= 0) {
            n3 -= n5;
        }
        if (n4 != n2) {
            throw TRAILING_CHARACTERS;
        }
        return BitsUtil.lpow10(bl ? -l : l, n3);
    }

    public static double parseDouble(byte[] byArray, int n, int n2) {
        int n3;
        boolean bl;
        if (n >= n2) {
            throw EMPTY_STRING;
        }
        int n4 = n;
        byte by = byArray[n4];
        if (FormatUtil.matchNaN(byArray, by, n4, n2)) {
            return Double.NaN;
        }
        boolean bl2 = bl = by == 45;
        if ((bl || by == 43) && ++n4 < n2) {
            by = byArray[n4];
        }
        if (FormatUtil.matchInf(byArray, by, n4, n2)) {
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if ((by < 48 || by > 57) && by != 46) {
            throw NOT_A_NUMBER;
        }
        long l = 0L;
        int n5 = -1;
        while (true) {
            if ((n3 = by - 48) >= 0 && n3 <= 9) {
                long l2 = (l << 3) + (l << 1) + (long)n3;
                if (l > 0xCCCCCCCCCCCCCCCL || l2 < l) {
                    throw PRECISION_OVERFLOW;
                }
                l = l2;
            } else {
                if (by != 46 || n5 >= 0) break;
                n5 = n4;
            }
            if (++n4 >= n2) break;
            by = byArray[n4];
        }
        n5 = n5 >= 0 ? n4 - n5 - 1 : 0;
        n3 = 0;
        if (n4 + 1 < n2 && (by == 69 || by == 101)) {
            int n6;
            boolean bl3;
            boolean bl4 = bl3 = (by = byArray[++n4]) == 45;
            if ((bl3 || by == 43) && ++n4 < n2) {
                by = byArray[n4];
            }
            if (by < 48 || by > 57) {
                throw INVALID_EXPONENT;
            }
            while ((n6 = by - 48) >= 0 && n6 < 10) {
                int n7 = (n3 << 3) + (n3 << 1) + n6;
                if (n3 > 0xCCCCCCC || n7 < n3) {
                    throw EXPONENT_OVERFLOW;
                }
                n3 = n7;
                if (++n4 >= n2) break;
                by = byArray[n4];
            }
            if (bl3) {
                n3 = -n3;
            }
        }
        if (n5 >= 0) {
            n3 -= n5;
        }
        if (n4 != n2) {
            throw TRAILING_CHARACTERS;
        }
        return BitsUtil.lpow10(bl ? -l : l, n3);
    }

    private static boolean matchNaN(CharSequence charSequence, char c, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 2 || n3 > 3) {
            return false;
        }
        if (c != 'N' && c != 'n') {
            return false;
        }
        char c2 = charSequence.charAt(n + 1);
        if (c2 != 'a' && c2 != 'A') {
            return false;
        }
        if (n3 == 2) {
            return true;
        }
        char c3 = charSequence.charAt(n + 2);
        return c3 == 'N' || c3 == 'n';
    }

    private static boolean matchNaN(byte[] byArray, byte by, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 2 || n3 > 3) {
            return false;
        }
        if (by != 78 && by != 110) {
            return false;
        }
        byte by2 = byArray[n + 1];
        if (by2 != 97 && by2 != 65) {
            return false;
        }
        if (n3 == 2) {
            return true;
        }
        byte by3 = byArray[n + 2];
        return by3 == 78 || by3 == 110;
    }

    private static boolean matchInf(CharSequence charSequence, char c, int n, int n2) {
        int n3 = n2 - n;
        if (n3 == 1 && c == '\u221e') {
            return true;
        }
        if (n3 != 3 && n3 != INFINITY_LENGTH) {
            return false;
        }
        if (c != 'I' && c != 'i') {
            return false;
        }
        int n4 = 1;
        int n5 = INFINITY_LENGTH + 1;
        while (n4 < INFINITY_LENGTH) {
            char c2 = charSequence.charAt(n + n4);
            if (c2 != INFINITY_PATTERN[n4] && c2 != INFINITY_PATTERN[n5]) {
                return false;
            }
            if (n4 == 2 && n3 == 3) {
                return true;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    private static boolean matchInf(byte[] byArray, byte by, int n, int n2) {
        int n3 = n2 - n;
        if (n3 == 1 && by == 8734) {
            return true;
        }
        if (n3 != 3 && n3 != INFINITY_LENGTH) {
            return false;
        }
        if (by != 73 && by != 105) {
            return false;
        }
        int n4 = 1;
        int n5 = INFINITY_LENGTH + 1;
        while (n4 < INFINITY_LENGTH) {
            byte by2 = byArray[n + n4];
            if (by2 != INFINITY_PATTERN[n4] && by2 != INFINITY_PATTERN[n5]) {
                return false;
            }
            if (n4 == 2 && n3 == 3) {
                return true;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    public static long parseLongBase10(CharSequence charSequence, int n, int n2) {
        int n3;
        boolean bl;
        int n4 = n;
        char c = charSequence.charAt(n4);
        boolean bl2 = bl = c == '-';
        if ((bl || c == '+') && ++n4 < n2) {
            c = charSequence.charAt(n4);
        }
        if (c < '0' || c > '9') {
            throw NOT_A_NUMBER;
        }
        long l = 0L;
        while ((n3 = c - 48) >= 0 && n3 <= 9) {
            long l2 = (l << 3) + (l << 1) + (long)n3;
            if (l2 < l) {
                throw PRECISION_OVERFLOW;
            }
            l = l2;
            if (++n4 >= n2) break;
            c = charSequence.charAt(n4);
        }
        if (n4 != n2) {
            throw TRAILING_CHARACTERS;
        }
        return bl ? -l : l;
    }

    public static StringBuilder format(boolean bl, StringBuilder stringBuilder) {
        return stringBuilder.append(bl ? "true" : "false");
    }

    public static StringBuilder formatBit(boolean bl, StringBuilder stringBuilder) {
        return stringBuilder.append(bl ? (char)'1' : '0');
    }

    public static StringBuilder format(int n, StringBuilder stringBuilder) {
        return stringBuilder.append(n);
    }

    public static StringBuilder format(long l, StringBuilder stringBuilder) {
        return stringBuilder.append(l);
    }

    public static StringBuilder appendZeros(StringBuilder stringBuilder, int n) {
        for (int i = n; i > 0; i -= ZEROPADDING.length) {
            stringBuilder.append(ZEROPADDING, 0, i < ZEROPADDING.length ? i : ZEROPADDING.length);
        }
        return stringBuilder;
    }

    public static StringBuilder appendSpace(StringBuilder stringBuilder, int n) {
        for (int i = n; i > 0; i -= SPACEPADDING.length) {
            stringBuilder.append(SPACEPADDING, 0, i < SPACEPADDING.length ? i : SPACEPADDING.length);
        }
        return stringBuilder;
    }

    public static int stringSize(int n) {
        if (n < 0) {
            return n == Integer.MIN_VALUE ? 11 : FormatUtil.stringSize(-n) + 1;
        }
        return n < 10000 ? (n < 100 ? (n < 10 ? 1 : 2) : (n < 1000 ? 3 : 4)) : (n < 1000000 ? (n < 100000 ? 5 : 6) : (n < 100000000 ? (n < 10000000 ? 7 : 8) : (n < 1000000000 ? 9 : 10)));
    }

    public static int stringSize(long l) {
        if (l < 0L) {
            return l == Long.MIN_VALUE ? 20 : FormatUtil.stringSize(-l) + 1;
        }
        return l <= Integer.MAX_VALUE ? FormatUtil.stringSize((int)l) : (l < 10000000000000L ? (l < 100000000000L ? (l < 10000000000L ? 10 : 11) : (l < 1000000000000L ? 12 : 13)) : (l < 1000000000000000L ? (l < 100000000000000L ? 14 : 15) : (l < 100000000000000000L ? (l < 10000000000000000L ? 16 : 17) : (l < 1000000000000000000L ? 18 : 19))));
    }

    static {
        NF.setMinimumFractionDigits(0);
        NF.setMaximumFractionDigits(8);
        NF.setGroupingUsed(false);
        NF0.setMinimumFractionDigits(0);
        NF0.setMaximumFractionDigits(0);
        NF0.setGroupingUsed(false);
        NF2.setMinimumFractionDigits(2);
        NF2.setMaximumFractionDigits(2);
        NF2.setGroupingUsed(false);
        NF3.setMinimumFractionDigits(3);
        NF3.setMaximumFractionDigits(3);
        NF3.setGroupingUsed(false);
        NF4.setMinimumFractionDigits(4);
        NF4.setMaximumFractionDigits(4);
        NF4.setGroupingUsed(false);
        NF6.setMinimumFractionDigits(6);
        NF6.setMaximumFractionDigits(6);
        NF6.setGroupingUsed(false);
        NF8.setMinimumFractionDigits(8);
        NF8.setMaximumFractionDigits(8);
        NF8.setGroupingUsed(false);
        NEWLINE = System.getProperty("line.separator");
        TIME_UNIT_SIZES = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L};
        TIME_UNIT_NAMES = new String[]{"ms", "s", "m", "h", "d"};
        TIME_UNIT_DIGITS = new int[]{3, 2, 2, 2, 2};
        EMPTY_STRING = new NumberFormatException("Parser called on an empty string."){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        EXPONENT_OVERFLOW = new NumberFormatException("Precision overflow for double exponent."){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        INVALID_EXPONENT = new NumberFormatException("Invalid exponent"){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        TRAILING_CHARACTERS = new NumberFormatException("String sequence was not completely consumed."){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        PRECISION_OVERFLOW = new NumberFormatException("Precision overflow for long values."){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        NOT_A_NUMBER = new NumberFormatException("Number must start with a digit or dot."){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
        INFINITY_PATTERN = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y', 'i', 'N', 'F', 'I', 'N', 'I', 'T', 'Y'};
        INFINITY_LENGTH = INFINITY_PATTERN.length >> 1;
        ZEROPADDING = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        SPACEPADDING = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    }
}

