/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike;

import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import java.util.Arrays;

public class IntegerArray
implements NumberArrayAdapter<Integer, IntegerArray> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFFA;
    private static final int LAST_GROW_SIZE = 0x55555551;
    public int[] data;
    public int size;

    public IntegerArray() {
        this(11);
    }

    public IntegerArray(int n) {
        if (n < 0) {
            n = 11;
        } else if (n > 0x7FFFFFFA) {
            n = 0x7FFFFFFA;
        }
        this.data = new int[n];
        this.size = 0;
    }

    public IntegerArray(IntegerArray integerArray) {
        this.data = Arrays.copyOf(integerArray.data, integerArray.size);
        this.size = integerArray.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void add(int n) {
        if (this.data.length == this.size) {
            this.grow();
        }
        this.data[this.size++] = n;
    }

    private void grow() throws OutOfMemoryError {
        if (this.data.length == 0x7FFFFFFA) {
            throw new OutOfMemoryError("Array size has reached the Java maximum.");
        }
        int n = this.size >= 0x55555551 ? 0x7FFFFFFA : this.size + (this.size >> 1) + 1;
        this.data = Arrays.copyOf(this.data, n);
    }

    public int get(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public void set(int n, int n2) {
        if (n < 0 || n > this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == this.size) {
            this.add(n2);
            return;
        }
        this.data[n] = n2;
    }

    public void remove(int n, int n2) {
        int n3 = n + n2;
        if (n3 > this.size) {
            throw new ArrayIndexOutOfBoundsException(this.size);
        }
        System.arraycopy(this.data, n3, this.data, n, this.size - n3);
        this.size -= n2;
    }

    public void insert(int n, int n2) {
        if (this.size == this.data.length) {
            if (this.data.length == 0x7FFFFFFA) {
                throw new OutOfMemoryError("Array size has reached the Java maximum.");
            }
            int n3 = this.size >= 0x55555551 ? 0x7FFFFFFA : this.size + (this.size >> 1) + 1;
            int[] nArray = this.data;
            this.data = new int[n3];
            System.arraycopy(nArray, 0, this.data, 0, n);
            System.arraycopy(nArray, n, this.data, n + 1, this.size - n);
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = n2;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    @Override
    public int size(IntegerArray integerArray) {
        return integerArray.size;
    }

    @Override
    public Integer get(IntegerArray integerArray, int n) throws IndexOutOfBoundsException {
        return integerArray.data[n];
    }

    @Override
    public double getDouble(IntegerArray integerArray, int n) throws IndexOutOfBoundsException {
        return integerArray.data[n];
    }

    @Override
    public float getFloat(IntegerArray integerArray, int n) throws IndexOutOfBoundsException {
        return integerArray.data[n];
    }

    @Override
    public int getInteger(IntegerArray integerArray, int n) throws IndexOutOfBoundsException {
        return integerArray.data[n];
    }

    @Override
    public short getShort(IntegerArray integerArray, int n) throws IndexOutOfBoundsException {
        return (short)integerArray.data[n];
    }

    @Override
    public long getLong(IntegerArray integerArray, int n) throws IndexOutOfBoundsException {
        return integerArray.data[n];
    }

    @Override
    public byte getByte(IntegerArray integerArray, int n) throws IndexOutOfBoundsException {
        return (byte)integerArray.data[n];
    }

    public int[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }
}

