/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleArrayListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.List;

public class GlobalVectorListElementSizeConstraint
implements GlobalParameterConstraint {
    private DoubleArrayListParameter vector;
    private IntParameter size;

    public GlobalVectorListElementSizeConstraint(DoubleArrayListParameter doubleArrayListParameter, IntParameter intParameter) {
        this.vector = doubleArrayListParameter;
        this.size = intParameter;
    }

    @Override
    public void test() throws ParameterException {
        if (!this.vector.isDefined()) {
            return;
        }
        for (double[] dArray : (List)this.vector.getValue()) {
            if (dArray.length == this.size.intValue()) continue;
            throw new WrongParameterValueException("Global Parameter Constraint Error.\nThe vectors of vector list parameter " + this.vector.getName() + " have not the required dimension of " + this.size.getValue() + " given by integer parameter " + this.size.getName() + ".");
        }
    }

    @Override
    public String getDescription() {
        return "The dimensionality of the vectors of vector list parameter " + this.vector.getName() + " must have the value of integer parameter " + this.size.getName();
    }
}

