/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import java.util.ArrayList;
import java.util.List;

public class ObjectListParameter<C>
extends ClassListParameter<C> {
    private ArrayList<C> instances = null;

    public ObjectListParameter(OptionID optionID, Class<?> clazz, boolean bl) {
        super(optionID, clazz, bl);
    }

    public ObjectListParameter(OptionID optionID, Class<?> clazz) {
        super(optionID, clazz);
    }

    @Override
    public String getSyntax() {
        return "<object_1|class_1,...,object_n|class_n>";
    }

    @Override
    protected List<Class<? extends C>> parseValue(Object object) throws ParameterException {
        if (object == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (List.class.isInstance(object)) {
            List list = (List)object;
            ArrayList arrayList = new ArrayList(list.size());
            ArrayList<Class> arrayList2 = new ArrayList<Class>(list.size());
            for (Object e : list) {
                if (this.restrictionClass.isInstance(e)) {
                    arrayList.add(e);
                    arrayList2.add(e.getClass());
                    continue;
                }
                if (e instanceof Class) {
                    if (this.restrictionClass.isAssignableFrom((Class)e)) {
                        arrayList.add(null);
                        arrayList2.add((Class)e);
                        continue;
                    }
                    throw new WrongParameterValueException(this, ((Class)e).getName(), "Given class not a subclass / implementation of " + this.restrictionClass.getName());
                }
                throw new WrongParameterValueException(this, e.getClass().getName(), "Given instance not an implementation of " + this.restrictionClass.getName());
            }
            this.instances = arrayList;
            return super.parseValue(arrayList2);
        }
        try {
            Object t = this.restrictionClass.cast(object);
            this.instances = new ArrayList(1);
            this.instances.add(t);
            return super.parseValue(t.getClass());
        }
        catch (ClassCastException classCastException) {
            return super.parseValue(object);
        }
    }

    @Override
    public List<C> instantiateClasses(Parameterization parameterization) {
        if (this.instances == null) {
            this.instances = new ArrayList(super.instantiateClasses(parameterization));
        } else {
            Parameterization parameterization2 = null;
            for (int i = 0; i < this.instances.size(); ++i) {
                if (this.instances.get(i) != null) continue;
                Class clazz = (Class)((List)this.getValue()).get(i);
                try {
                    if (parameterization2 == null) {
                        parameterization2 = parameterization.descend(this);
                    }
                    Object c = ClassGenericsUtil.tryInstantiate(this.restrictionClass, clazz, parameterization2);
                    this.instances.set(i, c);
                    continue;
                }
                catch (Exception exception) {
                    parameterization.reportError(new WrongParameterValueException(this, clazz.getName(), exception));
                }
            }
        }
        return new ArrayList<C>(this.instances);
    }
}

