/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.util.Arrays;

public class LogRankingPseudoOutlierScaling
implements OutlierScalingFunction {
    private double[] scores;
    private boolean inverted = false;

    @Override
    public void prepare(OutlierResult outlierResult) {
        DoubleRelation doubleRelation = outlierResult.getScores();
        this.scores = new double[doubleRelation.size()];
        int n = 0;
        if (outlierResult.getOutlierMeta() instanceof InvertedOutlierScoreMeta) {
            this.inverted = true;
        }
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            this.scores[n] = doubleRelation.doubleValue(dBIDIter);
            ++n;
            dBIDIter.advance();
        }
        if (n != doubleRelation.size()) {
            throw new AbortException("Database size is incorrect!");
        }
        Arrays.sort(this.scores);
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        this.scores = ArrayLikeUtil.toPrimitiveDoubleArray(a, numberArrayAdapter);
        Arrays.sort(this.scores);
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getScaled(double d) {
        assert (this.scores != null) : "prepare() was not run prior to using the scaling function.";
        int n = Arrays.binarySearch(this.scores, d);
        if (this.inverted) {
            return Math.log1p(1.0 - (double)n / ((double)this.scores.length - 1.0));
        }
        return Math.log1p((double)n / ((double)this.scores.length - 1.0));
    }
}

