/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;

public final class BatikUtil {
    public static double[] getRelativeCoordinates(Event event, Element element) {
        if (event instanceof DOMMouseEvent && element instanceof SVGLocatable && element instanceof SVGElement) {
            DOMMouseEvent dOMMouseEvent = (DOMMouseEvent)event;
            SVGMatrix sVGMatrix = ((SVGLocatable)((Object)element)).getScreenCTM();
            SVGMatrix sVGMatrix2 = sVGMatrix.inverse();
            SVGPoint sVGPoint = ((SVGElement)element).getOwnerSVGElement().createSVGPoint();
            sVGPoint.setX(dOMMouseEvent.getClientX());
            sVGPoint.setY(dOMMouseEvent.getClientY());
            sVGPoint = sVGPoint.matrixTransform(sVGMatrix2);
            return new double[]{sVGPoint.getX(), sVGPoint.getY()};
        }
        return null;
    }

    public static boolean hasFOPInstalled() {
        try {
            Class<?> clazz = Class.forName("org.apache.fop.svg.PDFTranscoder");
            Class<?> clazz2 = Class.forName("org.apache.fop.render.ps.PSTranscoder");
            Class<?> clazz3 = Class.forName("org.apache.fop.render.ps.EPSTranscoder");
            return clazz != null && clazz2 != null && clazz3 != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

