/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class DragableArea
implements EventListener {
    protected final Element element;
    protected final Element coordref;
    protected final SVGPlot svgp;
    protected SVGPoint startDragPoint = null;
    protected DragListener listener = null;

    public DragableArea(SVGPlot sVGPlot, double d, double d2, double d3, double d4) {
        this.svgp = sVGPlot;
        this.element = sVGPlot.svgRect(d, d2, d3, d4);
        this.makeInvisible();
        this.coordref = this.element;
        this.enableStart();
    }

    public DragableArea(SVGPlot sVGPlot, Element element, double d, double d2, double d3, double d4) {
        this.svgp = sVGPlot;
        this.element = sVGPlot.svgRect(d, d2, d3, d4);
        this.makeInvisible();
        this.coordref = element;
        this.enableStart();
    }

    public DragableArea(SVGPlot sVGPlot, double d, double d2, double d3, double d4, DragListener dragListener) {
        this.svgp = sVGPlot;
        this.element = sVGPlot.svgRect(d, d2, d3, d4);
        this.makeInvisible();
        this.coordref = this.element;
        this.listener = dragListener;
        this.enableStart();
    }

    public DragableArea(SVGPlot sVGPlot, Element element, double d, double d2, double d3, double d4, DragListener dragListener) {
        this.svgp = sVGPlot;
        this.element = sVGPlot.svgRect(d, d2, d3, d4);
        this.makeInvisible();
        this.coordref = element;
        this.listener = dragListener;
        this.enableStart();
    }

    public void destroy() {
        this.disableStart();
        this.disableStop();
    }

    public Element getElement() {
        return this.element;
    }

    public void enableStart() {
        EventTarget eventTarget = (EventTarget)((Object)this.element);
        eventTarget.addEventListener("mousedown", this, false);
    }

    public void disableStart() {
        EventTarget eventTarget = (EventTarget)((Object)this.element);
        eventTarget.removeEventListener("mousedown", this, false);
    }

    protected void enableStop() {
        SVGSVGElement sVGSVGElement = this.svgp.getDocument().getRootElement();
        sVGSVGElement.addEventListener("mousemove", this, false);
        sVGSVGElement.addEventListener("mouseup", this, false);
        sVGSVGElement.addEventListener("mouseout", this, false);
    }

    protected void disableStop() {
        SVGSVGElement sVGSVGElement = this.svgp.getDocument().getRootElement();
        sVGSVGElement.removeEventListener("mousemove", this, false);
        sVGSVGElement.removeEventListener("mouseup", this, false);
        sVGSVGElement.removeEventListener("mouseout", this, false);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.getType().equals("mousedown")) {
            SVGPoint sVGPoint = this.getCoordinates(event);
            if (this.startDrag(sVGPoint, event)) {
                this.startDragPoint = sVGPoint;
                this.enableStop();
            }
        } else if (event.getType().equals("mousemove")) {
            SVGPoint sVGPoint;
            if (this.startDragPoint != null && !this.duringDrag(this.startDragPoint, sVGPoint = this.getCoordinates(event), event, event.getTarget() == this.element)) {
                this.startDragPoint = null;
                this.disableStop();
            }
        } else if (event.getType().equals("mouseup")) {
            SVGPoint sVGPoint;
            if (this.startDragPoint != null && this.endDrag(this.startDragPoint, sVGPoint = this.getCoordinates(event), event, event.getTarget() == this.element)) {
                this.startDragPoint = null;
                this.disableStop();
            }
        } else if (event.getType().equals("mouseout")) {
            SVGPoint sVGPoint;
            if (this.startDragPoint != null && event.getTarget() == event.getCurrentTarget() && this.endDrag(this.startDragPoint, sVGPoint = this.getCoordinates(event), event, false)) {
                this.startDragPoint = null;
                this.disableStop();
            }
        } else {
            LoggingUtil.warning("Unrecognized event: " + event);
        }
    }

    protected SVGPoint getCoordinates(Event event) {
        return SVGUtil.elementCoordinatesFromEvent(this.svgp.getDocument(), this.coordref, event);
    }

    protected boolean startDrag(SVGPoint sVGPoint, Event event) {
        if (this.listener != null) {
            return this.listener.startDrag(sVGPoint, event);
        }
        return true;
    }

    protected boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
        if (this.listener != null) {
            return this.listener.duringDrag(sVGPoint, sVGPoint2, event, bl);
        }
        return true;
    }

    protected boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
        if (this.listener != null) {
            return this.listener.endDrag(sVGPoint, sVGPoint2, event, bl);
        }
        return true;
    }

    public void makeInvisible() {
        CSSClass cSSClass = new CSSClass(this, "unused");
        cSSClass.setStatement("fill-opacity", "0");
        cSSClass.setStatement("cursor", "pointer");
        SVGUtil.setAtt(this.element, "style", cSSClass.inlineCSS());
    }

    public void makeVisible() {
        CSSClass cSSClass = new CSSClass(this, "unused");
        cSSClass.setStatement("fill", "green");
        cSSClass.setStatement("fill-opacity", "0.2");
        cSSClass.setStatement("cursor", "pointer");
        SVGUtil.setAtt(this.element, "style", cSSClass.inlineCSS());
    }

    public static interface DragListener {
        public boolean startDrag(SVGPoint var1, Event var2);

        public boolean duringDrag(SVGPoint var1, SVGPoint var2, Event var3, boolean var4);

        public boolean endDrag(SVGPoint var1, SVGPoint var2, Event var3, boolean var4);
    }
}

