/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGArrow;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class AxisReorderVisualization
extends AbstractVisFactory {
    private static final String NAME = "Dimension Ordering Tool";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, parallelPlotProjector.getRelation(), parallelPlotProjector.getRelation(), this);
            visualizationTask.level = 1000;
            visualizationTask.addFlags(5);
            visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            iter.advance();
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String SELECTDIMENSIONORDER = "SelectDimensionOrder";
        public static final String SDO_BUTTON = "DObutton";
        public static final String SDO_BORDER = "DOborder";
        public static final String SDO_ARROW = "DOarrow";
        private int selecteddim;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.selecteddim = -1;
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            int n = this.proj.getVisibleDimensions();
            double d = 0.025 * this.getSizeY();
            double d2 = 0.75 * d;
            double d3 = 0.125 * d;
            double d4 = 0.75 * d2;
            double d5 = this.getSizeY() + this.getMarginTop() * 0.5 + d;
            double d6 = 0.9 * d;
            Element element = this.svgp.svgRect(-d * 0.5, d5, this.getSizeX() + d, d);
            SVGUtil.addCSSClass(element, SELECTDIMENSIONORDER);
            this.layer.appendChild(element);
            if (this.selecteddim < 0) {
                for (int i = 0; i < n; ++i) {
                    Element element2;
                    Element element3;
                    double d7 = this.getVisibleAxisX(i);
                    if (i > 0) {
                        element3 = SVGArrow.makeArrow(this.svgp, SVGArrow.LEFT, d7 - d6, d5 + d * 0.5, d4);
                        SVGUtil.addCSSClass(element3, SDO_ARROW);
                        this.layer.appendChild(element3);
                        element2 = this.svgp.svgRect(d7 - d6 - d2 * 0.5, d5 + d3, d2, d2);
                        SVGUtil.addCSSClass(element2, SDO_BUTTON);
                        this.addEventListener(element2, i, SVGArrow.LEFT);
                        this.layer.appendChild(element2);
                    }
                    element3 = SVGArrow.makeArrow(this.svgp, SVGArrow.DOWN, d7, d5 + d * 0.5, d4);
                    SVGUtil.addCSSClass(element3, SDO_ARROW);
                    this.layer.appendChild(element3);
                    element2 = this.svgp.svgRect(d7 - d2 * 0.5, d5 + d3, d2, d2);
                    SVGUtil.addCSSClass(element2, SDO_BUTTON);
                    this.addEventListener(element2, i, SVGArrow.DOWN);
                    this.layer.appendChild(element2);
                    if (i >= n - 1) continue;
                    element3 = SVGArrow.makeArrow(this.svgp, SVGArrow.RIGHT, d7 + d6, d5 + d * 0.5, d4);
                    SVGUtil.addCSSClass(element3, SDO_ARROW);
                    this.layer.appendChild(element3);
                    element2 = this.svgp.svgRect(d7 + d6 - d2 * 0.5, d5 + d3, d2, d2);
                    SVGUtil.addCSSClass(element2, SDO_BUTTON);
                    this.addEventListener(element2, i, SVGArrow.RIGHT);
                    this.layer.appendChild(element2);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Element element4 = SVGArrow.makeArrow(this.svgp, SVGArrow.DOWN, this.getVisibleAxisX(i), d5 + d * 0.5, d4);
                    SVGUtil.addCSSClass(element4, SDO_ARROW);
                    this.layer.appendChild(element4);
                    Element element5 = this.svgp.svgRect(this.getVisibleAxisX(i) - d2 * 0.5, d5 + d3, d2, d2);
                    SVGUtil.addCSSClass(element5, SDO_BUTTON);
                    this.addEventListener(element5, i, SVGArrow.DOWN);
                    this.layer.appendChild(element5);
                    if (!((double)i > 0.0)) continue;
                    element4 = SVGArrow.makeArrow(this.svgp, SVGArrow.UP, this.getVisibleAxisX((double)i - 0.5), d5 + d * 0.5, d4);
                    SVGUtil.addCSSClass(element4, SDO_ARROW);
                    this.layer.appendChild(element4);
                    element5 = this.svgp.svgRect(this.getVisibleAxisX((double)i - 0.5) - d2 * 0.5, d5 + d3, d2, d2);
                    SVGUtil.addCSSClass(element5, SDO_BUTTON);
                    this.addEventListener(element5, i, SVGArrow.UP);
                    this.layer.appendChild(element5);
                }
            }
        }

        private void addEventListener(Element element, final int n, final SVGArrow.Direction direction) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            eventTarget.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event event) {
                    if (Instance.this.selecteddim < 0) {
                        switch (direction) {
                            case DOWN: {
                                Instance.this.selecteddim = n;
                                break;
                            }
                            case LEFT: {
                                int n2;
                                for (n2 = n - 1; n2 >= 0 && !Instance.this.proj.isAxisVisible(n2); --n2) {
                                }
                                Instance.this.proj.swapAxes(n, n2);
                                break;
                            }
                            case RIGHT: {
                                int n3;
                                for (n3 = n + 1; n3 < Instance.this.proj.getInputDimensionality() - 1 && !Instance.this.proj.isAxisVisible(n3); ++n3) {
                                }
                                Instance.this.proj.swapAxes(n, n3);
                                break;
                            }
                        }
                    } else {
                        switch (direction) {
                            case DOWN: {
                                Instance.this.proj.swapAxes(Instance.this.selecteddim, n);
                                Instance.this.selecteddim = -1;
                                break;
                            }
                            case UP: {
                                if (Instance.this.selecteddim != n) {
                                    Instance.this.proj.moveAxis(Instance.this.selecteddim, n);
                                }
                                Instance.this.selecteddim = -1;
                                break;
                            }
                        }
                    }
                    Instance.this.context.visChanged(Instance.this.proj);
                }
            }, false);
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            CSSClass cSSClass;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!sVGPlot.getCSSClassManager().contains(SELECTDIMENSIONORDER)) {
                cSSClass = new CSSClass(this, SELECTDIMENSIONORDER);
                cSSClass.setStatement("opacity", 0.1);
                cSSClass.setStatement("fill", "blue");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(SDO_BORDER)) {
                cSSClass = new CSSClass(this, SDO_BORDER);
                cSSClass.setStatement("stroke", "grey");
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") / 3.0);
                cSSClass.setStatement("fill", "none");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(SDO_BUTTON)) {
                cSSClass = new CSSClass(this, SDO_BUTTON);
                cSSClass.setStatement("opacity", 0.01);
                cSSClass.setStatement("fill", "grey");
                cSSClass.setStatement("cursor", "pointer");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(SDO_ARROW)) {
                cSSClass = new CSSClass(this, SDO_ARROW);
                cSSClass.setStatement("stroke", "darkgrey");
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") / 3.0);
                cSSClass.setStatement("fill", "black");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

