/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.result.PixmapResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.awt.image.RenderedImage;
import org.w3c.dom.Element;

public class PixmapVisualizer
extends AbstractVisFactory {
    private static final String NAME = "Pixmap Visualizer";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<PixmapResult> iter = VisualizationTree.filterResults(visualizerContext, object, PixmapResult.class);
        while (iter.valid()) {
            PixmapResult pixmapResult = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, pixmapResult, null, this);
            visualizationTask.reqwidth = (double)pixmapResult.getImage().getWidth() / (double)pixmapResult.getImage().getHeight();
            visualizationTask.reqheight = 1.0;
            visualizationTask.level = 200;
            visualizerContext.addVis(pixmapResult, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractVisualization {
        private PixmapResult result;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2) {
            super(visualizationTask, visualizationPlot, d, d2);
            this.result = (PixmapResult)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            double d = 100.0 * this.getHeight() / this.getWidth();
            this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            String string = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), 100.0, d, 0.0);
            SVGUtil.setAtt(this.layer, "transform", string);
            RenderedImage renderedImage = this.result.getImage();
            double d2 = renderedImage.getHeight() / renderedImage.getWidth();
            double d3 = this.getHeight() / this.getWidth();
            double d4 = d2 >= d3 ? Math.min(d3 / d2, 1.0) : Math.max(d2 / d3, 1.0);
            Element element = this.svgp.svgElement("image");
            SVGUtil.setAtt(element, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(element, "x", 0);
            SVGUtil.setAtt(element, "y", 0);
            SVGUtil.setAtt(element, "width", 100.0 * d4 * d2);
            SVGUtil.setAtt(element, "height", 100.0 * d4);
            element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", this.result.getAsFile().toURI().toString());
            this.layer.appendChild(element);
        }
    }
}

