/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.List;

public class AlgorithmStep
implements WorkflowStep {
    private static final Logging LOG = Logging.getLogger(AlgorithmStep.class);
    private List<Algorithm> algorithms;
    private Result stepresult;

    public AlgorithmStep(List<Algorithm> list) {
        this.algorithms = list;
    }

    public Result runAlgorithms(Database database) {
        ResultHierarchy resultHierarchy = database.getHierarchy();
        if (LOG.isStatistics()) {
            boolean bl = true;
            Hierarchy.Iter<Database> object = resultHierarchy.iterDescendants(database);
            while (object.valid()) {
                if (object.get() instanceof Index) {
                    if (bl) {
                        LOG.statistics("Index statistics before running algorithms:");
                        bl = false;
                    }
                    ((Index)((Object)object.get())).logStatistics();
                }
                object.advance();
            }
        }
        this.stepresult = new BasicResult("Algorithm Step", "algorithm-step");
        for (Algorithm algorithm : this.algorithms) {
            Thread.currentThread().setName(algorithm.toString());
            Duration duration = LOG.isStatistics() ? LOG.newDuration(algorithm.getClass().getName() + ".runtime").begin() : null;
            Result result = algorithm.run(database);
            if (duration != null) {
                LOG.statistics(duration.end());
            }
            if (LOG.isStatistics()) {
                boolean bl = true;
                Hierarchy.Iter<Database> iter = resultHierarchy.iterDescendants(database);
                while (iter.valid()) {
                    if (iter.get() instanceof Index) {
                        if (bl) {
                            LOG.statistics("Index statistics after running algorithm " + algorithm.toString() + ":");
                            bl = false;
                        }
                        ((Index)((Object)iter.get())).logStatistics();
                    }
                    iter.advance();
                }
            }
            if (result == null) continue;
            resultHierarchy.add(database, result);
        }
        return this.stepresult;
    }

    public Result getResult() {
        return this.stepresult;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected boolean time = false;
        protected List<Algorithm> algorithms;
        public static final OptionID TIME_ID = new OptionID("time", "Enable logging of runtime data. Do not combine with more verbose logging, since verbose logging can significantly impact performance.");
        public static final OptionID ALGORITHM_ID = new OptionID("algorithm", "Algorithm to run.");

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectListParameter objectListParameter;
            super.makeOptions(parameterization);
            Flag flag = new Flag(TIME_ID);
            if (parameterization.grab(flag)) {
                this.time = (Boolean)flag.getValue();
            }
            if (parameterization.grab(objectListParameter = new ObjectListParameter(ALGORITHM_ID, Algorithm.class))) {
                this.algorithms = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected AlgorithmStep makeInstance() {
            if (this.time) {
                LoggingConfiguration.setStatistics();
            }
            return new AlgorithmStep(this.algorithms);
        }
    }
}

