/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.builder.CompareToBuilder;

public class CultureMemoryCell
implements Serializable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.13 $";
    private String m_name;
    private int m_version;
    private Object m_value;
    private int m_readAccessed;
    private int m_historySize;
    private int m_internalHistorySize;
    private CultureMemoryCell m_previousVersion;
    private List m_history;
    private long m_dateTimeVersion;

    public CultureMemoryCell() {
        this(null);
    }

    public CultureMemoryCell(String a_name) {
        this(a_name, 3);
    }

    public CultureMemoryCell(String a_name, int a_historySize) {
        this.setHistorySize(a_historySize);
        this.m_history = new Vector(this.getHistorySize());
        this.setName(a_name);
    }

    public void setName(String a_name) {
        this.m_name = a_name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setValue(Object a_value) {
        if (this.m_historySize > 0) {
            this.keepHistory(a_value, this.getVersion(), this.getName());
        } else {
            this.m_previousVersion = this.getNewInstance(this.m_value, this.getVersion(), this.getName());
        }
        this.m_value = a_value;
        this.incrementVersion();
    }

    public void setDouble(double a_value) {
        this.setValue(new Double(a_value));
    }

    public double getCurrentValueAsDouble() {
        return (Double)this.getCurrentValue();
    }

    public Object getCurrentValue() {
        ++this.m_readAccessed;
        return this.m_value;
    }

    public List getHistory() {
        return this.m_history;
    }

    public int getVersion() {
        return this.m_version;
    }

    protected void incrementVersion() {
        ++this.m_version;
        this.m_dateTimeVersion = System.currentTimeMillis();
    }

    protected void keepHistory(Object a_value, int a_version, String a_name) {
        this.trimHistory(this.m_historySize - 1);
        CultureMemoryCell cell = this.getNewInstance(a_value, a_version, a_name);
        cell.m_internalHistorySize = this.m_historySize;
        this.m_history.add(cell);
    }

    protected CultureMemoryCell getNewInstance(Object a_value, int a_version, String a_name) {
        CultureMemoryCell cell = new CultureMemoryCell(a_name, 0);
        cell.m_value = a_value;
        cell.m_version = a_version;
        return cell;
    }

    public int getReadAccessed() {
        return this.m_readAccessed;
    }

    public int getReadAccessedCurrentVersion() {
        if (this.m_historySize < 1) {
            return this.getReadAccessed() - this.m_previousVersion.getReadAccessed();
        }
        CultureMemoryCell cell = (CultureMemoryCell)this.m_history.get(this.m_history.size() - 1);
        return this.getReadAccessed() - cell.getReadAccessed();
    }

    public void setHistorySize(int a_size) {
        if (this.getHistory() != null && a_size > this.getHistory().size()) {
            this.trimHistory(a_size);
            this.m_historySize = a_size;
        } else {
            this.m_historySize = a_size < 0 ? 0 : a_size;
        }
    }

    protected void trimHistory(int a_size) {
        while (this.m_history.size() > a_size) {
            this.m_history.remove(0);
        }
    }

    public int getHistorySize() {
        return this.m_historySize;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.toStringRecursive(result, this.getHistorySize());
        return result.toString();
    }

    protected void toStringRecursive(StringBuffer a_result, int a_historySize) {
        List history = this.getHistory();
        a_result.append("[Name:" + this.getName() + ";");
        a_result.append("Value:" + this.m_value + ";");
        a_result.append("Version:" + this.getVersion() + ";");
        a_result.append("Read accessed:" + this.getReadAccessed() + ";");
        a_result.append("History Size:" + a_historySize + ";");
        a_result.append("History:[");
        for (int i = 0; i < history.size(); ++i) {
            if (i > 0) {
                a_result.append(";");
            }
            CultureMemoryCell cell = (CultureMemoryCell)history.get(i);
            cell.toStringRecursive(a_result, cell.m_internalHistorySize);
            a_result.append("]");
        }
        a_result.append("]");
    }

    public long getVersionTimeMilliseconds() {
        return this.m_dateTimeVersion;
    }

    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public int compareTo(Object a_other) {
        CultureMemoryCell other = (CultureMemoryCell)a_other;
        if (other == null) {
            return 1;
        }
        return new CompareToBuilder().append(this.m_value, other.m_value).append(this.m_version, other.m_version).append(this.m_historySize, other.m_historySize).toComparison();
    }
}

