/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class AddAndStore
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.13 $";
    private String m_storageName;
    private Class m_type;

    public AddAndStore(GPConfiguration a_conf, Class a_type, String a_storageName) throws InvalidConfigurationException {
        super(a_conf, 2, CommandGene.VoidClass);
        this.m_type = a_type;
        this.m_storageName = a_storageName;
    }

    public String toString() {
        return "Store(" + this.m_storageName + ", &1 + &2)";
    }

    public String getName() {
        return "AddAndStore";
    }

    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        Number value = null;
        if (this.m_type == CommandGene.IntegerClass) {
            value = new Integer(c.execute_int(n, 0, args) + c.execute_int(n, 1, args));
        } else if (this.m_type == CommandGene.LongClass) {
            value = new Long(c.execute_long(n, 0, args) + c.execute_long(n, 1, args));
        } else if (this.m_type == CommandGene.DoubleClass) {
            value = new Double(c.execute_double(n, 0, args) + c.execute_double(n, 1, args));
        } else if (this.m_type == CommandGene.FloatClass) {
            value = new Float(c.execute_float(n, 0, args) + c.execute_float(n, 1, args));
        } else {
            throw new RuntimeException("Type " + this.m_type + " not supported by AddAndStore");
        }
        this.getGPConfiguration().storeInMemory(this.m_storageName, value);
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return this.m_type;
    }

    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        AddAndStore other = (AddAndStore)a_other;
        return new CompareToBuilder().append((Object)this.m_type, (Object)other.m_type).append((Object)this.m_storageName, (Object)other.m_storageName).toComparison();
    }

    public boolean equals(Object a_other) {
        try {
            AddAndStore other = (AddAndStore)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_type, (Object)other.m_type).append((Object)this.m_storageName, (Object)other.m_storageName).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            AddAndStore result = new AddAndStore(this.getGPConfiguration(), this.m_type, this.m_storageName);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

