/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.wfg;

import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;

public class Transformations {
    private static final float EPSILON = 1.0E-10f;

    public float bPoly(float y, float alpha) throws JMetalException {
        if (!(alpha > 0.0f)) {
            JMetalLogger.logger.severe("wfg.Transformations.bPoly: Param alpha must be > 0");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMetalException("Exception in " + name + ".bPoly()");
        }
        return this.correctTo01((float)StrictMath.pow(y, alpha));
    }

    public float bFlat(float y, float A, float B, float C) {
        float tmp1 = Math.min(0.0f, (float)Math.floor(y - B)) * A * (B - y) / B;
        float tmp2 = Math.min(0.0f, (float)Math.floor(C - y)) * (1.0f - A) * (y - C) / (1.0f - C);
        return this.correctTo01(A + tmp1 - tmp2);
    }

    public float sLinear(float y, float A) {
        return this.correctTo01(Math.abs(y - A) / (float)Math.abs(Math.floor(A - y) + (double)A));
    }

    public float sDecept(float y, float A, float B, float C) {
        float tmp1 = (float)Math.floor(y - A + B) * (1.0f - C + (A - B) / B) / (A - B);
        float tmp2 = (float)Math.floor(A + B - y) * (1.0f - C + (1.0f - A - B) / B) / (1.0f - A - B);
        float tmp = Math.abs(y - A) - B;
        return this.correctTo01(1.0f + tmp * (tmp1 + tmp2 + 1.0f / B));
    }

    public float sMulti(float y, int A, int B, float C) {
        float tmp1 = (4.0f * (float)A + 2.0f) * (float)Math.PI * (0.5f - Math.abs(y - C) / (2.0f * ((float)Math.floor(C - y) + C)));
        float tmp2 = 4.0f * (float)B * (float)StrictMath.pow(Math.abs(y - C) / (2.0f * ((float)Math.floor(C - y) + C)), 2.0);
        return this.correctTo01((1.0f + (float)Math.cos(tmp1) + tmp2) / ((float)B + 2.0f));
    }

    public float rSum(float[] y, float[] w) {
        float tmp1 = 0.0f;
        float tmp2 = 0.0f;
        for (int i = 0; i < y.length; ++i) {
            tmp1 += y[i] * w[i];
            tmp2 += w[i];
        }
        return this.correctTo01(tmp1 / tmp2);
    }

    public float rNonsep(float[] y, int A) {
        float tmp = (float)Math.ceil((float)A / 2.0f);
        float denominator = (float)y.length * tmp * (1.0f + 2.0f * (float)A - 2.0f * tmp) / (float)A;
        float numerator = 0.0f;
        for (int j = 0; j < y.length; ++j) {
            numerator += y[j];
            for (int k = 0; k <= A - 2; ++k) {
                numerator += Math.abs(y[j] - y[(j + k + 1) % y.length]);
            }
        }
        return this.correctTo01(numerator / denominator);
    }

    public float bParam(float y, float u, float A, float B, float C) {
        float v = A - (1.0f - 2.0f * u) * Math.abs((float)Math.floor(0.5f - u) + A);
        float exp = B + (C - B) * v;
        float result = (float)StrictMath.pow(y, exp);
        return this.correctTo01(result);
    }

    float correctTo01(float a) {
        float min = 0.0f;
        float max = 1.0f;
        float min_epsilon = min - 1.0E-10f;
        float max_epsilon = max + 1.0E-10f;
        if (a <= min && a >= min_epsilon || a >= min && a <= min_epsilon) {
            return min;
        }
        if (a >= max && a <= max_epsilon || a <= max && a >= max_epsilon) {
            return max;
        }
        return a;
    }
}

