/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SolutionUtils {
    private static JMetalRandom randomGenerator = JMetalRandom.getInstance();

    public static <S extends Solution<?>> S getBestSolution(S solution1, S solution2, Comparator<S> comparator) {
        int flag = comparator.compare(solution1, solution2);
        S result = flag == -1 ? solution1 : (flag == 1 ? solution2 : (randomGenerator.nextDouble() < 0.5 ? solution1 : solution2));
        return result;
    }

    static <S extends Solution<?>> double distanceBetweenObjectives(S firstSolution, S secondSolution) {
        double distance = 0.0;
        for (int nObj = 0; nObj < firstSolution.getNumberOfObjectives(); ++nObj) {
            double diff = firstSolution.getObjective(nObj) - secondSolution.getObjective(nObj);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public static double distanceToSolutionListInSolutionSpace(DoubleSolution solution, List<DoubleSolution> solutionList) {
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < solutionList.size(); ++i) {
            double aux = SolutionUtils.distanceBetweenSolutions(solution, solutionList.get(i));
            if (!(aux < distance)) continue;
            distance = aux;
        }
        return distance;
    }

    public static double distanceBetweenSolutions(DoubleSolution solutionI, DoubleSolution solutionJ) {
        double distance = 0.0;
        for (int i = 0; i < solutionI.getNumberOfVariables(); ++i) {
            double diff = (Double)solutionI.getVariableValue(i) - (Double)solutionJ.getVariableValue(i);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }
}

