/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Random;
import weka.core.Aggregateable;
import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class NormalEstimator
extends Estimator
implements IncrementalEstimator,
Aggregateable<NormalEstimator> {
    private static final long serialVersionUID = 93584379632315841L;
    private double m_SumOfWeights;
    private double m_SumOfValues;
    private double m_SumOfValuesSq;
    private double m_Mean;
    private double m_StandardDev;
    private double m_Precision;

    private double round(double data) {
        return Math.rint(data / this.m_Precision) * this.m_Precision;
    }

    public NormalEstimator(double precision) {
        this.m_Precision = precision;
        this.m_StandardDev = this.m_Precision / 6.0;
    }

    @Override
    public void addValue(double data, double weight) {
        if (weight == 0.0) {
            return;
        }
        data = this.round(data);
        this.m_SumOfWeights += weight;
        this.m_SumOfValues += data * weight;
        this.m_SumOfValuesSq += data * data * weight;
        this.computeParameters();
    }

    protected void computeParameters() {
        if (this.m_SumOfWeights > 0.0) {
            this.m_Mean = this.m_SumOfValues / this.m_SumOfWeights;
            double stdDev = Math.sqrt(Math.abs(this.m_SumOfValuesSq - this.m_Mean * this.m_SumOfValues) / this.m_SumOfWeights);
            if (stdDev > 1.0E-10) {
                this.m_StandardDev = Math.max(this.m_Precision / 6.0, stdDev);
            }
        }
    }

    @Override
    public double getProbability(double data) {
        data = this.round(data);
        double zLower = (data - this.m_Mean - this.m_Precision / 2.0) / this.m_StandardDev;
        double zUpper = (data - this.m_Mean + this.m_Precision / 2.0) / this.m_StandardDev;
        double pLower = Statistics.normalProbability(zLower);
        double pUpper = Statistics.normalProbability(zUpper);
        return pUpper - pLower;
    }

    public String toString() {
        return "Normal Distribution. Mean = " + Utils.doubleToString(this.m_Mean, 4) + " StandardDev = " + Utils.doubleToString(this.m_StandardDev, 4) + " WeightSum = " + Utils.doubleToString(this.m_SumOfWeights, 4) + " Precision = " + this.m_Precision + "\n";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        if (!this.m_noClass) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        } else {
            result.enable(Capabilities.Capability.NO_CLASS);
        }
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    public double getMean() {
        return this.m_Mean;
    }

    public double getStdDev() {
        return this.m_StandardDev;
    }

    public double getPrecision() {
        return this.m_Precision;
    }

    public double getSumOfWeights() {
        return this.m_SumOfWeights;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9785 $");
    }

    @Override
    public NormalEstimator aggregate(NormalEstimator toAggregate) throws Exception {
        this.m_SumOfWeights += toAggregate.m_SumOfWeights;
        this.m_SumOfValues += toAggregate.m_SumOfValues;
        this.m_SumOfValuesSq += toAggregate.m_SumOfValuesSq;
        if (toAggregate.m_Precision < this.m_Precision) {
            this.m_Precision = toAggregate.m_Precision;
        }
        this.computeParameters();
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
    }

    public static void testAggregation() {
        NormalEstimator ne = new NormalEstimator(0.01);
        NormalEstimator one = new NormalEstimator(0.01);
        NormalEstimator two = new NormalEstimator(0.01);
        Random r = new Random(1L);
        int i = 0;
        while (i < 100) {
            double z = r.nextDouble();
            ne.addValue(z, 1.0);
            if (i < 50) {
                one.addValue(z, 1.0);
            } else {
                two.addValue(z, 1.0);
            }
            ++i;
        }
        try {
            System.out.println("\n\nFull\n");
            System.out.println(ne.toString());
            System.out.println("Prob (0): " + ne.getProbability(0.0));
            System.out.println("\nOne\n" + one.toString());
            System.out.println("Prob (0): " + one.getProbability(0.0));
            System.out.println("\nTwo\n" + two.toString());
            System.out.println("Prob (0): " + two.getProbability(0.0));
            one = one.aggregate(two);
            System.out.println("\nAggregated\n");
            System.out.println(one.toString());
            System.out.println("Prob (0): " + one.getProbability(0.0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            NormalEstimator newEst = new NormalEstimator(0.01);
            int i = 0;
            while (i < argv.length) {
                double current = Double.valueOf(argv[i]);
                System.out.println(newEst);
                System.out.println("Prediction for " + current + " = " + newEst.getProbability(current));
                newEst.addValue(current, 1.0);
                ++i;
            }
            NormalEstimator.testAggregation();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

