/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.coerce;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epsilon.emc.emf.util.EListUtil;
import org.eclipse.epsilon.hutn.model.hutn.AttributeSlot;
import org.eclipse.epsilon.hutn.xmi.coerce.AbstractCoercionStrategy;

public class PrimitiveCoercionStrategy
extends AbstractCoercionStrategy {
    public PrimitiveCoercionStrategy(AttributeSlot slot) {
        super(slot);
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    public AttributeSlot coerce() {
        if (EListUtil.elementsAreAllOfSameType(this.coercedValues())) {
            this.slot.setValues(this.coercedValues());
        }
        return this.slot;
    }

    private EList<Object> coercedValues() {
        BasicEList<Object> coercedValues = new BasicEList<Object>();
        for (String value : this.values) {
            coercedValues.add(new SerialisedValue(value).coerce());
        }
        return coercedValues;
    }

    private static class SerialisedValue {
        private final String value;

        public SerialisedValue(String value) {
            this.value = value;
        }

        public Object coerce() {
            if (this.isFloat(this.value)) {
                return Float.valueOf(this.toFloat(this.value));
            }
            if (this.isInteger(this.value)) {
                return this.toInteger(this.value);
            }
            if (this.isBoolean(this.value)) {
                return this.toBoolean(this.value);
            }
            return this.value;
        }

        private boolean isBoolean(String value) {
            return value.matches("true|false");
        }

        private boolean toBoolean(String value) {
            return Boolean.parseBoolean(value);
        }

        private boolean isInteger(String value) {
            return value.matches("-?\\d+");
        }

        private int toInteger(String value) {
            return Integer.parseInt(value);
        }

        private boolean isFloat(String value) {
            return value.matches("-?\\d*\\.\\d+");
        }

        private float toFloat(String value) {
            return Float.parseFloat(value);
        }
    }
}

